@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.cloudwatch.kotlin.inputs

import com.pulumi.aws.cloudwatch.inputs.InternetMonitorInternetMeasurementsLogDeliveryArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property s3Config
 */
public data class InternetMonitorInternetMeasurementsLogDeliveryArgs(
    public val s3Config: Output<InternetMonitorInternetMeasurementsLogDeliveryS3ConfigArgs>? = null,
) :
    ConvertibleToJava<com.pulumi.aws.cloudwatch.inputs.InternetMonitorInternetMeasurementsLogDeliveryArgs> {
    override fun toJava():
        com.pulumi.aws.cloudwatch.inputs.InternetMonitorInternetMeasurementsLogDeliveryArgs =
        com.pulumi.aws.cloudwatch.inputs.InternetMonitorInternetMeasurementsLogDeliveryArgs.builder()
            .s3Config(s3Config?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [InternetMonitorInternetMeasurementsLogDeliveryArgs].
 */
@PulumiTagMarker
public class InternetMonitorInternetMeasurementsLogDeliveryArgsBuilder internal constructor() {
    private var s3Config: Output<InternetMonitorInternetMeasurementsLogDeliveryS3ConfigArgs>? = null

    /**
     * @param value
     */
    @JvmName("xxdnlcmxltejcwqw")
    public suspend
    fun s3Config(`value`: Output<InternetMonitorInternetMeasurementsLogDeliveryS3ConfigArgs>) {
        this.s3Config = value
    }

    /**
     * @param value
     */
    @JvmName("iqyqgreoqvlsndxr")
    public suspend
    fun s3Config(`value`: InternetMonitorInternetMeasurementsLogDeliveryS3ConfigArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.s3Config = mapped
    }

    /**
     * @param argument
     */
    @JvmName("dfsncydwyqhaxfni")
    public suspend
    fun s3Config(argument: suspend InternetMonitorInternetMeasurementsLogDeliveryS3ConfigArgsBuilder.() -> Unit) {
        val toBeMapped =
            InternetMonitorInternetMeasurementsLogDeliveryS3ConfigArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.s3Config = mapped
    }

    internal fun build(): InternetMonitorInternetMeasurementsLogDeliveryArgs =
        InternetMonitorInternetMeasurementsLogDeliveryArgs(
            s3Config = s3Config,
        )
}
