@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.cloudwatch.kotlin.inputs

import com.pulumi.aws.cloudwatch.inputs.InternetMonitorInternetMeasurementsLogDeliveryS3ConfigArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property bucketName
 * @property bucketPrefix
 * @property logDeliveryStatus
 */
public data class InternetMonitorInternetMeasurementsLogDeliveryS3ConfigArgs(
    public val bucketName: Output<String>,
    public val bucketPrefix: Output<String>? = null,
    public val logDeliveryStatus: Output<String>? = null,
) :
    ConvertibleToJava<com.pulumi.aws.cloudwatch.inputs.InternetMonitorInternetMeasurementsLogDeliveryS3ConfigArgs> {
    override fun toJava():
        com.pulumi.aws.cloudwatch.inputs.InternetMonitorInternetMeasurementsLogDeliveryS3ConfigArgs =
        com.pulumi.aws.cloudwatch.inputs.InternetMonitorInternetMeasurementsLogDeliveryS3ConfigArgs.builder()
            .bucketName(bucketName.applyValue({ args0 -> args0 }))
            .bucketPrefix(bucketPrefix?.applyValue({ args0 -> args0 }))
            .logDeliveryStatus(logDeliveryStatus?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [InternetMonitorInternetMeasurementsLogDeliveryS3ConfigArgs].
 */
@PulumiTagMarker
public class InternetMonitorInternetMeasurementsLogDeliveryS3ConfigArgsBuilder internal
constructor() {
    private var bucketName: Output<String>? = null

    private var bucketPrefix: Output<String>? = null

    private var logDeliveryStatus: Output<String>? = null

    /**
     * @param value
     */
    @JvmName("uvtplrexdybpjrys")
    public suspend fun bucketName(`value`: Output<String>) {
        this.bucketName = value
    }

    /**
     * @param value
     */
    @JvmName("aifcojgrqbvlctit")
    public suspend fun bucketPrefix(`value`: Output<String>) {
        this.bucketPrefix = value
    }

    /**
     * @param value
     */
    @JvmName("ncwwhhgyyxggarus")
    public suspend fun logDeliveryStatus(`value`: Output<String>) {
        this.logDeliveryStatus = value
    }

    /**
     * @param value
     */
    @JvmName("bxudkbwcpwupowvl")
    public suspend fun bucketName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.bucketName = mapped
    }

    /**
     * @param value
     */
    @JvmName("lqngnudmiowuuuxm")
    public suspend fun bucketPrefix(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.bucketPrefix = mapped
    }

    /**
     * @param value
     */
    @JvmName("lwavawfxraugrmxe")
    public suspend fun logDeliveryStatus(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.logDeliveryStatus = mapped
    }

    internal fun build(): InternetMonitorInternetMeasurementsLogDeliveryS3ConfigArgs =
        InternetMonitorInternetMeasurementsLogDeliveryS3ConfigArgs(
            bucketName = bucketName ?: throw PulumiNullFieldException("bucketName"),
            bucketPrefix = bucketPrefix,
            logDeliveryStatus = logDeliveryStatus,
        )
}
