@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.cloudwatch.kotlin.inputs

import com.pulumi.aws.cloudwatch.inputs.MetricAlarmMetricQueryMetricArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 *
 * @property dimensions The dimensions for this metric.  For the list of available dimensions see the AWS documentation [here](http://docs.aws.amazon.com/AmazonCloudWatch/latest/DeveloperGuide/CW_Support_For_AWS.html).
 * @property metricName The name for this metric.
 * See docs for [supported metrics](https://docs.aws.amazon.com/AmazonCloudWatch/latest/DeveloperGuide/CW_Support_For_AWS.html).
 * @property namespace The namespace for this metric. See docs for the [list of namespaces](https://docs.aws.amazon.com/AmazonCloudWatch/latest/DeveloperGuide/aws-namespaces.html).
 * See docs for [supported metrics](https://docs.aws.amazon.com/AmazonCloudWatch/latest/DeveloperGuide/CW_Support_For_AWS.html).
 * @property period Granularity in seconds of returned data points.
 * For metrics with regular resolution, valid values are any multiple of `60`.
 * For high-resolution metrics, valid values are `1`, `5`, `10`, `30`, or any multiple of `60`.
 * @property stat The statistic to apply to this metric.
 * See docs for [supported statistics](https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/Statistics-definitions.html).
 * @property unit The unit for this metric.
 */
public data class MetricAlarmMetricQueryMetricArgs(
    public val dimensions: Output<Map<String, String>>? = null,
    public val metricName: Output<String>,
    public val namespace: Output<String>? = null,
    public val period: Output<Int>,
    public val stat: Output<String>,
    public val unit: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.cloudwatch.inputs.MetricAlarmMetricQueryMetricArgs> {
    override fun toJava(): com.pulumi.aws.cloudwatch.inputs.MetricAlarmMetricQueryMetricArgs =
        com.pulumi.aws.cloudwatch.inputs.MetricAlarmMetricQueryMetricArgs.builder()
            .dimensions(
                dimensions?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            )
            .metricName(metricName.applyValue({ args0 -> args0 }))
            .namespace(namespace?.applyValue({ args0 -> args0 }))
            .period(period.applyValue({ args0 -> args0 }))
            .stat(stat.applyValue({ args0 -> args0 }))
            .unit(unit?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [MetricAlarmMetricQueryMetricArgs].
 */
@PulumiTagMarker
public class MetricAlarmMetricQueryMetricArgsBuilder internal constructor() {
    private var dimensions: Output<Map<String, String>>? = null

    private var metricName: Output<String>? = null

    private var namespace: Output<String>? = null

    private var period: Output<Int>? = null

    private var stat: Output<String>? = null

    private var unit: Output<String>? = null

    /**
     * @param value The dimensions for this metric.  For the list of available dimensions see the AWS documentation [here](http://docs.aws.amazon.com/AmazonCloudWatch/latest/DeveloperGuide/CW_Support_For_AWS.html).
     */
    @JvmName("hbelwcdwaoaculuv")
    public suspend fun dimensions(`value`: Output<Map<String, String>>) {
        this.dimensions = value
    }

    /**
     * @param value The name for this metric.
     * See docs for [supported metrics](https://docs.aws.amazon.com/AmazonCloudWatch/latest/DeveloperGuide/CW_Support_For_AWS.html).
     */
    @JvmName("qinipbmjtpcagnvy")
    public suspend fun metricName(`value`: Output<String>) {
        this.metricName = value
    }

    /**
     * @param value The namespace for this metric. See docs for the [list of namespaces](https://docs.aws.amazon.com/AmazonCloudWatch/latest/DeveloperGuide/aws-namespaces.html).
     * See docs for [supported metrics](https://docs.aws.amazon.com/AmazonCloudWatch/latest/DeveloperGuide/CW_Support_For_AWS.html).
     */
    @JvmName("vdgpjcaispfboqyf")
    public suspend fun namespace(`value`: Output<String>) {
        this.namespace = value
    }

    /**
     * @param value Granularity in seconds of returned data points.
     * For metrics with regular resolution, valid values are any multiple of `60`.
     * For high-resolution metrics, valid values are `1`, `5`, `10`, `30`, or any multiple of `60`.
     */
    @JvmName("yhwinprhrhvosgwo")
    public suspend fun period(`value`: Output<Int>) {
        this.period = value
    }

    /**
     * @param value The statistic to apply to this metric.
     * See docs for [supported statistics](https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/Statistics-definitions.html).
     */
    @JvmName("tjiithotsdhvkgya")
    public suspend fun stat(`value`: Output<String>) {
        this.stat = value
    }

    /**
     * @param value The unit for this metric.
     */
    @JvmName("xsaekatpaoboskfv")
    public suspend fun unit(`value`: Output<String>) {
        this.unit = value
    }

    /**
     * @param value The dimensions for this metric.  For the list of available dimensions see the AWS documentation [here](http://docs.aws.amazon.com/AmazonCloudWatch/latest/DeveloperGuide/CW_Support_For_AWS.html).
     */
    @JvmName("llsufpuevlveerdq")
    public suspend fun dimensions(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dimensions = mapped
    }

    /**
     * @param values The dimensions for this metric.  For the list of available dimensions see the AWS documentation [here](http://docs.aws.amazon.com/AmazonCloudWatch/latest/DeveloperGuide/CW_Support_For_AWS.html).
     */
    @JvmName("djmknetuuchelboi")
    public fun dimensions(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.dimensions = mapped
    }

    /**
     * @param value The name for this metric.
     * See docs for [supported metrics](https://docs.aws.amazon.com/AmazonCloudWatch/latest/DeveloperGuide/CW_Support_For_AWS.html).
     */
    @JvmName("hgxighsfjxowsdkk")
    public suspend fun metricName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.metricName = mapped
    }

    /**
     * @param value The namespace for this metric. See docs for the [list of namespaces](https://docs.aws.amazon.com/AmazonCloudWatch/latest/DeveloperGuide/aws-namespaces.html).
     * See docs for [supported metrics](https://docs.aws.amazon.com/AmazonCloudWatch/latest/DeveloperGuide/CW_Support_For_AWS.html).
     */
    @JvmName("cvhjhhdgksydwlli")
    public suspend fun namespace(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.namespace = mapped
    }

    /**
     * @param value Granularity in seconds of returned data points.
     * For metrics with regular resolution, valid values are any multiple of `60`.
     * For high-resolution metrics, valid values are `1`, `5`, `10`, `30`, or any multiple of `60`.
     */
    @JvmName("ohiicbmrhjquhdye")
    public suspend fun period(`value`: Int) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.period = mapped
    }

    /**
     * @param value The statistic to apply to this metric.
     * See docs for [supported statistics](https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/Statistics-definitions.html).
     */
    @JvmName("woydcninitwpdetq")
    public suspend fun stat(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.stat = mapped
    }

    /**
     * @param value The unit for this metric.
     */
    @JvmName("xbfhafsmscrxarbo")
    public suspend fun unit(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.unit = mapped
    }

    internal fun build(): MetricAlarmMetricQueryMetricArgs = MetricAlarmMetricQueryMetricArgs(
        dimensions = dimensions,
        metricName = metricName ?: throw PulumiNullFieldException("metricName"),
        namespace = namespace,
        period = period ?: throw PulumiNullFieldException("period"),
        stat = stat ?: throw PulumiNullFieldException("stat"),
        unit = unit,
    )
}
