@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.cloudwatch.kotlin.inputs

import com.pulumi.aws.cloudwatch.inputs.MetricStreamStatisticsConfigurationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property additionalStatistics The additional statistics to stream for the metrics listed in `include_metrics`.
 * @property includeMetrics An array that defines the metrics that are to have additional statistics streamed. See details below.
 */
public data class MetricStreamStatisticsConfigurationArgs(
    public val additionalStatistics: Output<List<String>>,
    public val includeMetrics: Output<List<MetricStreamStatisticsConfigurationIncludeMetricArgs>>,
) : ConvertibleToJava<com.pulumi.aws.cloudwatch.inputs.MetricStreamStatisticsConfigurationArgs> {
    override fun toJava(): com.pulumi.aws.cloudwatch.inputs.MetricStreamStatisticsConfigurationArgs =
        com.pulumi.aws.cloudwatch.inputs.MetricStreamStatisticsConfigurationArgs.builder()
            .additionalStatistics(additionalStatistics.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .includeMetrics(
                includeMetrics.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [MetricStreamStatisticsConfigurationArgs].
 */
@PulumiTagMarker
public class MetricStreamStatisticsConfigurationArgsBuilder internal constructor() {
    private var additionalStatistics: Output<List<String>>? = null

    private var includeMetrics: Output<List<MetricStreamStatisticsConfigurationIncludeMetricArgs>>? =
        null

    /**
     * @param value The additional statistics to stream for the metrics listed in `include_metrics`.
     */
    @JvmName("nnjmcdtxcccxrijv")
    public suspend fun additionalStatistics(`value`: Output<List<String>>) {
        this.additionalStatistics = value
    }

    @JvmName("imwetkqlphmvirkh")
    public suspend fun additionalStatistics(vararg values: Output<String>) {
        this.additionalStatistics = Output.all(values.asList())
    }

    /**
     * @param values The additional statistics to stream for the metrics listed in `include_metrics`.
     */
    @JvmName("ojpsyqprubgvfpyu")
    public suspend fun additionalStatistics(values: List<Output<String>>) {
        this.additionalStatistics = Output.all(values)
    }

    /**
     * @param value An array that defines the metrics that are to have additional statistics streamed. See details below.
     */
    @JvmName("apgmuhmjubuoxdja")
    public suspend
    fun includeMetrics(`value`: Output<List<MetricStreamStatisticsConfigurationIncludeMetricArgs>>) {
        this.includeMetrics = value
    }

    @JvmName("ihkekppeaedyushb")
    public suspend fun includeMetrics(
        vararg
        values: Output<MetricStreamStatisticsConfigurationIncludeMetricArgs>,
    ) {
        this.includeMetrics = Output.all(values.asList())
    }

    /**
     * @param values An array that defines the metrics that are to have additional statistics streamed. See details below.
     */
    @JvmName("ckjqghiuuykkgaoj")
    public suspend
    fun includeMetrics(values: List<Output<MetricStreamStatisticsConfigurationIncludeMetricArgs>>) {
        this.includeMetrics = Output.all(values)
    }

    /**
     * @param value The additional statistics to stream for the metrics listed in `include_metrics`.
     */
    @JvmName("ylsnbsejrnmqewxc")
    public suspend fun additionalStatistics(`value`: List<String>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.additionalStatistics = mapped
    }

    /**
     * @param values The additional statistics to stream for the metrics listed in `include_metrics`.
     */
    @JvmName("rdmswqjyxwwlvlsi")
    public suspend fun additionalStatistics(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.additionalStatistics = mapped
    }

    /**
     * @param value An array that defines the metrics that are to have additional statistics streamed. See details below.
     */
    @JvmName("yravfenckpxyqdug")
    public suspend
    fun includeMetrics(`value`: List<MetricStreamStatisticsConfigurationIncludeMetricArgs>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.includeMetrics = mapped
    }

    /**
     * @param argument An array that defines the metrics that are to have additional statistics streamed. See details below.
     */
    @JvmName("fjxpstychkgdyrbg")
    public suspend
    fun includeMetrics(argument: List<suspend MetricStreamStatisticsConfigurationIncludeMetricArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            MetricStreamStatisticsConfigurationIncludeMetricArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.includeMetrics = mapped
    }

    /**
     * @param argument An array that defines the metrics that are to have additional statistics streamed. See details below.
     */
    @JvmName("ywgircldkqkstgth")
    public suspend fun includeMetrics(
        vararg
        argument: suspend MetricStreamStatisticsConfigurationIncludeMetricArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            MetricStreamStatisticsConfigurationIncludeMetricArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.includeMetrics = mapped
    }

    /**
     * @param argument An array that defines the metrics that are to have additional statistics streamed. See details below.
     */
    @JvmName("wmxfgsqnxqdxgfhb")
    public suspend
    fun includeMetrics(argument: suspend MetricStreamStatisticsConfigurationIncludeMetricArgsBuilder.() -> Unit) {
        val toBeMapped =
            listOf(
                MetricStreamStatisticsConfigurationIncludeMetricArgsBuilder().applySuspend {
                    argument()
                }.build(),
            )
        val mapped = of(toBeMapped)
        this.includeMetrics = mapped
    }

    /**
     * @param values An array that defines the metrics that are to have additional statistics streamed. See details below.
     */
    @JvmName("krnxbbsvhyltsekv")
    public suspend fun includeMetrics(
        vararg
        values: MetricStreamStatisticsConfigurationIncludeMetricArgs,
    ) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.includeMetrics = mapped
    }

    internal fun build(): MetricStreamStatisticsConfigurationArgs =
        MetricStreamStatisticsConfigurationArgs(
            additionalStatistics = additionalStatistics ?: throw
                PulumiNullFieldException("additionalStatistics"),
            includeMetrics = includeMetrics ?: throw PulumiNullFieldException("includeMetrics"),
        )
}
