@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.cloudwatch.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property alarm Can be an AlarmName or an Amazon Resource Name (ARN) from an existing alarm.
 * @property extensionPeriod The maximum time in seconds that the composite alarm waits after suppressor alarm goes out of the `ALARM` state. After this time, the composite alarm performs its actions.
 * @property waitPeriod The maximum time in seconds that the composite alarm waits for the suppressor alarm to go into the `ALARM` state. After this time, the composite alarm performs its actions.
 */
public data class CompositeAlarmActionsSuppressor(
    public val alarm: String,
    public val extensionPeriod: Int,
    public val waitPeriod: Int,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.aws.cloudwatch.outputs.CompositeAlarmActionsSuppressor):
            CompositeAlarmActionsSuppressor = CompositeAlarmActionsSuppressor(
            alarm = javaType.alarm(),
            extensionPeriod = javaType.extensionPeriod(),
            waitPeriod = javaType.waitPeriod(),
        )
    }
}
