@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.cloudwatch.kotlin.outputs

import kotlin.Suppress

/**
 *
 * @property apiKey Parameters used for API_KEY authorization. An API key to include in the header for each authentication request. A maximum of 1 are allowed. Conflicts with `basic` and `oauth`. Documented below.
 * @property basic Parameters used for BASIC authorization. A maximum of 1 are allowed. Conflicts with `api_key` and `oauth`. Documented below.
 * @property invocationHttpParameters Invocation Http Parameters are additional credentials used to sign each Invocation of the ApiDestination created from this Connection. If the ApiDestination Rule Target has additional HttpParameters, the values will be merged together, with the Connection Invocation Http Parameters taking precedence. Secret values are stored and managed by AWS Secrets Manager. A maximum of 1 are allowed. Documented below.
 * @property oauth Parameters used for OAUTH_CLIENT_CREDENTIALS authorization. A maximum of 1 are allowed. Conflicts with `basic` and `api_key`. Documented below.
 */
public data class EventConnectionAuthParameters(
    public val apiKey: EventConnectionAuthParametersApiKey? = null,
    public val basic: EventConnectionAuthParametersBasic? = null,
    public val invocationHttpParameters: EventConnectionAuthParametersInvocationHttpParameters? =
        null,
    public val oauth: EventConnectionAuthParametersOauth? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.cloudwatch.outputs.EventConnectionAuthParameters):
            EventConnectionAuthParameters = EventConnectionAuthParameters(
            apiKey = javaType.apiKey().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.cloudwatch.kotlin.outputs.EventConnectionAuthParametersApiKey.Companion.toKotlin(args0)
                })
            }).orElse(null),
            basic = javaType.basic().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.cloudwatch.kotlin.outputs.EventConnectionAuthParametersBasic.Companion.toKotlin(args0)
                })
            }).orElse(null),
            invocationHttpParameters = javaType.invocationHttpParameters().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.cloudwatch.kotlin.outputs.EventConnectionAuthParametersInvocationHttpParameters.Companion.toKotlin(args0)
                })
            }).orElse(null),
            oauth = javaType.oauth().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.cloudwatch.kotlin.outputs.EventConnectionAuthParametersOauth.Companion.toKotlin(args0)
                })
            }).orElse(null),
        )
    }
}
