@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.cloudwatch.kotlin.outputs

import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property bodies Contains additional body string parameters for the connection. You can include up to 100 additional body string parameters per request. Each additional parameter counts towards the event payload size, which cannot exceed 64 KB. Each parameter can contain the following:
 * @property headers Contains additional header parameters for the connection. You can include up to 100 additional body string parameters per request. Each additional parameter counts towards the event payload size, which cannot exceed 64 KB. Each parameter can contain the following:
 * @property queryStrings Contains additional query string parameters for the connection. You can include up to 100 additional body string parameters per request. Each additional parameter counts towards the event payload size, which cannot exceed 64 KB. Each parameter can contain the following:
 */
public data class EventConnectionAuthParametersInvocationHttpParameters(
    public val bodies: List<EventConnectionAuthParametersInvocationHttpParametersBody>? = null,
    public val headers: List<EventConnectionAuthParametersInvocationHttpParametersHeader>? = null,
    public val queryStrings: List<EventConnectionAuthParametersInvocationHttpParametersQueryString>? =
        null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.aws.cloudwatch.outputs.EventConnectionAuthParametersInvocationHttpParameters):
            EventConnectionAuthParametersInvocationHttpParameters =
            EventConnectionAuthParametersInvocationHttpParameters(
                bodies = javaType.bodies().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.cloudwatch.kotlin.outputs.EventConnectionAuthParametersInvocationHttpParametersBody.Companion.toKotlin(args0)
                    })
                }),
                headers = javaType.headers().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.cloudwatch.kotlin.outputs.EventConnectionAuthParametersInvocationHttpParametersHeader.Companion.toKotlin(args0)
                    })
                }),
                queryStrings = javaType.queryStrings().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.cloudwatch.kotlin.outputs.EventConnectionAuthParametersInvocationHttpParametersQueryString.Companion.toKotlin(args0)
                    })
                }),
            )
    }
}
