@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.cloudwatch.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property authorizationEndpoint The URL to the authorization endpoint.
 * @property clientParameters Contains the client parameters for OAuth authorization. Contains the following two parameters.
 * @property httpMethod A password for the authorization. Created and stored in AWS Secrets Manager.
 * @property oauthHttpParameters OAuth Http Parameters are additional credentials used to sign the request to the authorization endpoint to exchange the OAuth Client information for an access token. Secret values are stored and managed by AWS Secrets Manager. A maximum of 1 are allowed. Documented below.
 */
public data class EventConnectionAuthParametersOauth(
    public val authorizationEndpoint: String,
    public val clientParameters: EventConnectionAuthParametersOauthClientParameters? = null,
    public val httpMethod: String,
    public val oauthHttpParameters: EventConnectionAuthParametersOauthOauthHttpParameters,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.aws.cloudwatch.outputs.EventConnectionAuthParametersOauth):
            EventConnectionAuthParametersOauth = EventConnectionAuthParametersOauth(
            authorizationEndpoint = javaType.authorizationEndpoint(),
            clientParameters = javaType.clientParameters().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.cloudwatch.kotlin.outputs.EventConnectionAuthParametersOauthClientParameters.Companion.toKotlin(args0)
                })
            }).orElse(null),
            httpMethod = javaType.httpMethod(),
            oauthHttpParameters = javaType.oauthHttpParameters().let({ args0 ->
                com.pulumi.aws.cloudwatch.kotlin.outputs.EventConnectionAuthParametersOauthOauthHttpParameters.Companion.toKotlin(args0)
            }),
        )
    }
}
