@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.cloudwatch.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property clientId The client ID for the credentials to use for authorization. Created and stored in AWS Secrets Manager.
 * @property clientSecret The client secret for the credentials to use for authorization. Created and stored in AWS Secrets Manager.
 */
public data class EventConnectionAuthParametersOauthClientParameters(
    public val clientId: String,
    public val clientSecret: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.aws.cloudwatch.outputs.EventConnectionAuthParametersOauthClientParameters):
            EventConnectionAuthParametersOauthClientParameters =
            EventConnectionAuthParametersOauthClientParameters(
                clientId = javaType.clientId(),
                clientSecret = javaType.clientSecret(),
            )
    }
}
