@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.cloudwatch.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property state The state of event replication. Valid values: `ENABLED`, `DISABLED`. The default state is `ENABLED`, which means you must supply a `role_arn`. If you don't have a `role_arn` or you don't want event replication enabled, set `state` to `DISABLED`.
 */
public data class EventEndpointReplicationConfig(
    public val state: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.cloudwatch.outputs.EventEndpointReplicationConfig):
            EventEndpointReplicationConfig = EventEndpointReplicationConfig(
            state = javaType.state().map({ args0 -> args0 }).orElse(null),
        )
    }
}
