@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.cloudwatch.kotlin.outputs

import kotlin.Suppress

/**
 *
 * @property primary Parameters used for the primary Region. Documented below.
 * @property secondary Parameters used for the secondary Region, the Region that events are routed to when failover is triggered or event replication is enabled. Documented below.
 */
public data class EventEndpointRoutingConfigFailoverConfig(
    public val primary: EventEndpointRoutingConfigFailoverConfigPrimary,
    public val secondary: EventEndpointRoutingConfigFailoverConfigSecondary,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.aws.cloudwatch.outputs.EventEndpointRoutingConfigFailoverConfig):
            EventEndpointRoutingConfigFailoverConfig = EventEndpointRoutingConfigFailoverConfig(
            primary = javaType.primary().let({ args0 ->
                com.pulumi.aws.cloudwatch.kotlin.outputs.EventEndpointRoutingConfigFailoverConfigPrimary.Companion.toKotlin(args0)
            }),
            secondary = javaType.secondary().let({ args0 ->
                com.pulumi.aws.cloudwatch.kotlin.outputs.EventEndpointRoutingConfigFailoverConfigSecondary.Companion.toKotlin(args0)
            }),
        )
    }
}
