@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.cloudwatch.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property base The base value designates how many tasks, at a minimum, to run on the specified capacity provider. Only one capacity provider in a capacity provider strategy can have a base defined. Defaults to `0`.
 * @property capacityProvider Short name of the capacity provider.
 * @property weight The weight value designates the relative percentage of the total number of tasks launched that should use the specified capacity provider. The weight value is taken into consideration after the base value, if defined, is satisfied.
 */
public data class EventTargetEcsTargetCapacityProviderStrategy(
    public val base: Int? = null,
    public val capacityProvider: String,
    public val weight: Int? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.aws.cloudwatch.outputs.EventTargetEcsTargetCapacityProviderStrategy):
            EventTargetEcsTargetCapacityProviderStrategy = EventTargetEcsTargetCapacityProviderStrategy(
            base = javaType.base().map({ args0 -> args0 }).orElse(null),
            capacityProvider = javaType.capacityProvider(),
            weight = javaType.weight().map({ args0 -> args0 }).orElse(null),
        )
    }
}
