@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.cloudwatch.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 *
 * @property headerParameters Enables you to specify HTTP headers to add to the request.
 * @property pathParameterValues The list of values that correspond sequentially to any path variables in your endpoint ARN (for example `arn:aws:execute-api:us-east-1:123456:myapi/*/POST/pets/*`).
 * @property queryStringParameters Represents keys/values of query string parameters that are appended to the invoked endpoint.
 * */*/
 */
public data class EventTargetHttpTarget(
    public val headerParameters: Map<String, String>? = null,
    public val pathParameterValues: List<String>? = null,
    public val queryStringParameters: Map<String, String>? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.cloudwatch.outputs.EventTargetHttpTarget):
            EventTargetHttpTarget = EventTargetHttpTarget(
            headerParameters = javaType.headerParameters().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            pathParameterValues = javaType.pathParameterValues().map({ args0 -> args0 }),
            queryStringParameters = javaType.queryStringParameters().map({ args0 ->
                args0.key.to(args0.value)
            }).toMap(),
        )
    }
}
