@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.cloudwatch.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 *
 * @property inputPaths Key value pairs specified in the form of JSONPath (for example, time = $.time)
 * * You can have as many as 100 key-value pairs.
 * * You must use JSON dot notation, not bracket notation.
 * * The keys can't start with "AWS".
 * @property inputTemplate Template to customize data sent to the target. Must be valid JSON. To send a string value, the string value must include double quotes.
 */
public data class EventTargetInputTransformer(
    public val inputPaths: Map<String, String>? = null,
    public val inputTemplate: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.cloudwatch.outputs.EventTargetInputTransformer):
            EventTargetInputTransformer = EventTargetInputTransformer(
            inputPaths = javaType.inputPaths().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            inputTemplate = javaType.inputTemplate(),
        )
    }
}
