@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.cloudwatch.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property key Can be either `tag:tag-key` or `InstanceIds`.
 * @property values If Key is `tag:tag-key`, Values is a list of tag values. If Key is `InstanceIds`, Values is a list of Amazon EC2 instance IDs.
 */
public data class EventTargetRunCommandTarget(
    public val key: String,
    public val values: List<String>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.cloudwatch.outputs.EventTargetRunCommandTarget):
            EventTargetRunCommandTarget = EventTargetRunCommandTarget(
            key = javaType.key(),
            values = javaType.values().map({ args0 -> args0 }),
        )
    }
}
