@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.cloudwatch.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * A collection of values returned by getEventBus.
 * @property arn ARN.
 * @property id The provider-assigned unique ID for this managed resource.
 * @property name
 */
public data class GetEventBusResult(
    public val arn: String,
    public val id: String,
    public val name: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.cloudwatch.outputs.GetEventBusResult):
            GetEventBusResult = GetEventBusResult(
            arn = javaType.arn(),
            id = javaType.id(),
            name = javaType.name(),
        )
    }
}
