@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.cloudwatch.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * A collection of values returned by getEventSource.
 * @property arn ARN of the partner event source
 * @property createdBy Name of the SaaS partner that created the event source
 * @property id The provider-assigned unique ID for this managed resource.
 * @property name Name of the event source
 * @property namePrefix
 * @property state State of the event source (`ACTIVE` or `PENDING`)
 */
public data class GetEventSourceResult(
    public val arn: String,
    public val createdBy: String,
    public val id: String,
    public val name: String,
    public val namePrefix: String? = null,
    public val state: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.cloudwatch.outputs.GetEventSourceResult):
            GetEventSourceResult = GetEventSourceResult(
            arn = javaType.arn(),
            createdBy = javaType.createdBy(),
            id = javaType.id(),
            name = javaType.name(),
            namePrefix = javaType.namePrefix().map({ args0 -> args0 }).orElse(null),
            state = javaType.state(),
        )
    }
}
