@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.cloudwatch.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 * A collection of values returned by getLogGroup.
 * @property arn ARN of the Cloudwatch log group. Any `:*` suffix added by the API, denoting all CloudWatch Log Streams under the CloudWatch Log Group, is removed for greater compatibility with other AWS services that do not accept the suffix.
 * @property creationTime Creation time of the log group, expressed as the number of milliseconds after Jan 1, 1970 00:00:00 UTC.
 * @property id The provider-assigned unique ID for this managed resource.
 * @property kmsKeyId ARN of the KMS Key to use when encrypting log data.
 * @property name
 * @property retentionInDays Number of days log events retained in the specified log group.
 * @property tags Map of tags to assign to the resource.
 */
public data class GetLogGroupResult(
    public val arn: String,
    public val creationTime: Int,
    public val id: String,
    public val kmsKeyId: String,
    public val name: String,
    public val retentionInDays: Int,
    public val tags: Map<String, String>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.cloudwatch.outputs.GetLogGroupResult):
            GetLogGroupResult = GetLogGroupResult(
            arn = javaType.arn(),
            creationTime = javaType.creationTime(),
            id = javaType.id(),
            kmsKeyId = javaType.kmsKeyId(),
            name = javaType.name(),
            retentionInDays = javaType.retentionInDays(),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
        )
    }
}
