@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.cloudwatch.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A collection of values returned by getLogGroups.
 * @property arns Set of ARNs of the Cloudwatch log groups
 * @property id The provider-assigned unique ID for this managed resource.
 * @property logGroupNamePrefix
 * @property logGroupNames Set of names of the Cloudwatch log groups
 */
public data class GetLogGroupsResult(
    public val arns: List<String>,
    public val id: String,
    public val logGroupNamePrefix: String? = null,
    public val logGroupNames: List<String>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.cloudwatch.outputs.GetLogGroupsResult):
            GetLogGroupsResult = GetLogGroupsResult(
            arns = javaType.arns().map({ args0 -> args0 }),
            id = javaType.id(),
            logGroupNamePrefix = javaType.logGroupNamePrefix().map({ args0 -> args0 }).orElse(null),
            logGroupNames = javaType.logGroupNames().map({ args0 -> args0 }),
        )
    }
}
