@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.cloudwatch.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 *
 * @property defaultValue The value to emit when a filter pattern does not match a log event. Conflicts with `dimensions`.
 * @property dimensions Map of fields to use as dimensions for the metric. Up to 3 dimensions are allowed. Conflicts with `default_value`.
 * @property name The name of the CloudWatch metric to which the monitored log information should be published (e.g., `ErrorCount`)
 * @property namespace The destination namespace of the CloudWatch metric.
 * @property unit The unit to assign to the metric. If you omit this, the unit is set as `None`.
 * @property value What to publish to the metric. For example, if you're counting the occurrences of a particular term like "Error", the value will be "1" for each occurrence. If you're counting the bytes transferred the published value will be the value in the log event.
 */
public data class LogMetricFilterMetricTransformation(
    public val defaultValue: String? = null,
    public val dimensions: Map<String, String>? = null,
    public val name: String,
    public val namespace: String,
    public val unit: String? = null,
    public val `value`: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.aws.cloudwatch.outputs.LogMetricFilterMetricTransformation):
            LogMetricFilterMetricTransformation = LogMetricFilterMetricTransformation(
            defaultValue = javaType.defaultValue().map({ args0 -> args0 }).orElse(null),
            dimensions = javaType.dimensions().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            name = javaType.name(),
            namespace = javaType.namespace(),
            unit = javaType.unit().map({ args0 -> args0 }).orElse(null),
            `value` = javaType.`value`(),
        )
    }
}
