@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.cloudwatch.kotlin.outputs

import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property accountId The ID of the account where the metrics are located, if this is a cross-account alarm.
 * @property expression The math expression to be performed on the returned data, if this object is performing a math expression. This expression can use the id of the other metrics to refer to those metrics, and can also use the id of other expressions to use the result of those expressions. For more information about metric math expressions, see Metric Math Syntax and Functions in the [Amazon CloudWatch User Guide](https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/using-metric-math.html#metric-math-syntax).
 * @property id A short name used to tie this object to the results in the response. If you are performing math expressions on this set of data, this name represents that data and can serve as a variable in the mathematical expression. The valid characters are letters, numbers, and underscore. The first character must be a lowercase letter.
 * @property label A human-readable label for this metric or expression. This is especially useful if this is an expression, so that you know what the value represents.
 * @property metric The metric to be returned, along with statistics, period, and units. Use this parameter only if this object is retrieving a metric and not performing a math expression on returned data.
 * @property period Granularity in seconds of returned data points.
 * For metrics with regular resolution, valid values are any multiple of `60`.
 * For high-resolution metrics, valid values are `1`, `5`, `10`, `30`, or any multiple of `60`.
 * @property returnData Specify exactly one `metric_query` to be `true` to use that `metric_query` result as the alarm.
 * > **NOTE:**  You must specify either `metric` or `expression`. Not both.
 */
public data class MetricAlarmMetricQuery(
    public val accountId: String? = null,
    public val expression: String? = null,
    public val id: String,
    public val label: String? = null,
    public val metric: MetricAlarmMetricQueryMetric? = null,
    public val period: Int? = null,
    public val returnData: Boolean? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.cloudwatch.outputs.MetricAlarmMetricQuery):
            MetricAlarmMetricQuery = MetricAlarmMetricQuery(
            accountId = javaType.accountId().map({ args0 -> args0 }).orElse(null),
            expression = javaType.expression().map({ args0 -> args0 }).orElse(null),
            id = javaType.id(),
            label = javaType.label().map({ args0 -> args0 }).orElse(null),
            metric = javaType.metric().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.cloudwatch.kotlin.outputs.MetricAlarmMetricQueryMetric.Companion.toKotlin(args0)
                })
            }).orElse(null),
            period = javaType.period().map({ args0 -> args0 }).orElse(null),
            returnData = javaType.returnData().map({ args0 -> args0 }).orElse(null),
        )
    }
}
