@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.codeartifact.kotlin

import com.pulumi.aws.codeartifact.CodeartifactFunctions.getAuthorizationTokenPlain
import com.pulumi.aws.codeartifact.CodeartifactFunctions.getRepositoryEndpointPlain
import com.pulumi.aws.codeartifact.kotlin.inputs.GetAuthorizationTokenPlainArgs
import com.pulumi.aws.codeartifact.kotlin.inputs.GetAuthorizationTokenPlainArgsBuilder
import com.pulumi.aws.codeartifact.kotlin.inputs.GetRepositoryEndpointPlainArgs
import com.pulumi.aws.codeartifact.kotlin.inputs.GetRepositoryEndpointPlainArgsBuilder
import com.pulumi.aws.codeartifact.kotlin.outputs.GetAuthorizationTokenResult
import com.pulumi.aws.codeartifact.kotlin.outputs.GetRepositoryEndpointResult
import kotlinx.coroutines.future.await
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import com.pulumi.aws.codeartifact.kotlin.outputs.GetAuthorizationTokenResult.Companion.toKotlin as getAuthorizationTokenResultToKotlin
import com.pulumi.aws.codeartifact.kotlin.outputs.GetRepositoryEndpointResult.Companion.toKotlin as getRepositoryEndpointResultToKotlin

public object CodeartifactFunctions {
    /**
     * The CodeArtifact Authorization Token data source generates a temporary authentication token for accessing repositories in a CodeArtifact domain.
     * ## Example Usage
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.codeartifact.CodeartifactFunctions;
     * import com.pulumi.aws.codeartifact.inputs.GetAuthorizationTokenArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var test = CodeartifactFunctions.getAuthorizationToken(GetAuthorizationTokenArgs.builder()
     *             .domain(aws_codeartifact_domain.test().domain())
     *             .build());
     *     }
     * }
     * ```
     * @param argument A collection of arguments for invoking getAuthorizationToken.
     * @return A collection of values returned by getAuthorizationToken.
     */
    public suspend fun getAuthorizationToken(argument: GetAuthorizationTokenPlainArgs):
        GetAuthorizationTokenResult =
        getAuthorizationTokenResultToKotlin(getAuthorizationTokenPlain(argument.toJava()).await())

    /**
     * @see [getAuthorizationToken].
     * @param domain Name of the domain that is in scope for the generated authorization token.
     * @param domainOwner Account number of the AWS account that owns the domain.
     * @param durationSeconds Time, in seconds, that the generated authorization token is valid. Valid values are `0` and between `900` and `43200`.
     * @return A collection of values returned by getAuthorizationToken.
     */
    public suspend fun getAuthorizationToken(
        domain: String,
        domainOwner: String? = null,
        durationSeconds: Int? = null,
    ): GetAuthorizationTokenResult {
        val argument = GetAuthorizationTokenPlainArgs(
            domain = domain,
            domainOwner = domainOwner,
            durationSeconds = durationSeconds,
        )
        return getAuthorizationTokenResultToKotlin(getAuthorizationTokenPlain(argument.toJava()).await())
    }

    /**
     * @see [getAuthorizationToken].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;codeartifact&#46;kotlin&#46;inputs&#46;GetAuthorizationTokenPlainArgs].
     * @return A collection of values returned by getAuthorizationToken.
     */
    public suspend
    fun getAuthorizationToken(argument: suspend GetAuthorizationTokenPlainArgsBuilder.() -> Unit):
        GetAuthorizationTokenResult {
        val builder = GetAuthorizationTokenPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getAuthorizationTokenResultToKotlin(getAuthorizationTokenPlain(builtArgument.toJava()).await())
    }

    /**
     * The CodeArtifact Repository Endpoint data source returns the endpoint of a repository for a specific package format.
     * ## Example Usage
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.codeartifact.CodeartifactFunctions;
     * import com.pulumi.aws.codeartifact.inputs.GetRepositoryEndpointArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var test = CodeartifactFunctions.getRepositoryEndpoint(GetRepositoryEndpointArgs.builder()
     *             .domain(aws_codeartifact_domain.test().domain())
     *             .repository(aws_codeartifact_repository.test().repository())
     *             .format("npm")
     *             .build());
     *     }
     * }
     * ```
     * @param argument A collection of arguments for invoking getRepositoryEndpoint.
     * @return A collection of values returned by getRepositoryEndpoint.
     */
    public suspend fun getRepositoryEndpoint(argument: GetRepositoryEndpointPlainArgs):
        GetRepositoryEndpointResult =
        getRepositoryEndpointResultToKotlin(getRepositoryEndpointPlain(argument.toJava()).await())

    /**
     * @see [getRepositoryEndpoint].
     * @param domain Name of the domain that contains the repository.
     * @param domainOwner Account number of the AWS account that owns the domain.
     * @param format Which endpoint of a repository to return. A repository has one endpoint for each package format: `npm`, `pypi`, `maven`, and `nuget`.
     * @param repository Name of the repository.
     * @return A collection of values returned by getRepositoryEndpoint.
     */
    public suspend fun getRepositoryEndpoint(
        domain: String,
        domainOwner: String? = null,
        format: String,
        repository: String,
    ): GetRepositoryEndpointResult {
        val argument = GetRepositoryEndpointPlainArgs(
            domain = domain,
            domainOwner = domainOwner,
            format = format,
            repository = repository,
        )
        return getRepositoryEndpointResultToKotlin(getRepositoryEndpointPlain(argument.toJava()).await())
    }

    /**
     * @see [getRepositoryEndpoint].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;codeartifact&#46;kotlin&#46;inputs&#46;GetRepositoryEndpointPlainArgs].
     * @return A collection of values returned by getRepositoryEndpoint.
     */
    public suspend
    fun getRepositoryEndpoint(argument: suspend GetRepositoryEndpointPlainArgsBuilder.() -> Unit):
        GetRepositoryEndpointResult {
        val builder = GetRepositoryEndpointPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getRepositoryEndpointResultToKotlin(getRepositoryEndpointPlain(builtArgument.toJava()).await())
    }
}
