@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.codeartifact.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map

/**
 * Builder for [Domain].
 */
@PulumiTagMarker
public class DomainResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: DomainArgs = DomainArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend DomainArgsBuilder.() -> Unit) {
        val builder = DomainArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): Domain {
        val builtJavaResource = com.pulumi.aws.codeartifact.Domain(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Domain(builtJavaResource)
    }
}

/**
 * Provides a CodeArtifact Domain Resource.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.codeartifact.Domain;
 * import com.pulumi.aws.codeartifact.DomainArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Domain("example", DomainArgs.builder()
 *             .domain("example")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import CodeArtifact Domain using the CodeArtifact Domain arn. For example:
 * ```sh
 *  $ pulumi import aws:codeartifact/domain:Domain example arn:aws:codeartifact:us-west-2:012345678912:domain/tf-acc-test-8593714120730241305
 * ```
 *
 */
public class Domain internal constructor(
    override val javaResource: com.pulumi.aws.codeartifact.Domain,
) : KotlinCustomResource(javaResource, DomainMapper) {
    /**
     * The ARN of the Domain.
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * The total size of all assets in the domain.
     */
    public val assetSizeBytes: Output<String>
        get() = javaResource.assetSizeBytes().applyValue({ args0 -> args0 })

    /**
     * A timestamp that represents the date and time the domain was created in [RFC3339 format](https://tools.ietf.org/html/rfc3339#section-5.8).
     */
    public val createdTime: Output<String>
        get() = javaResource.createdTime().applyValue({ args0 -> args0 })

    /**
     * The name of the domain to create. All domain names in an AWS Region that are in the same AWS account must be unique. The domain name is used as the prefix in DNS hostnames. Do not use sensitive information in a domain name because it is publicly discoverable.
     */
    public val domain: Output<String>
        get() = javaResource.domain().applyValue({ args0 -> args0 })

    /**
     * The encryption key for the domain. This is used to encrypt content stored in a domain. The KMS Key Amazon Resource Name (ARN). The default aws/codeartifact AWS KMS master key is used if this element is absent.
     */
    public val encryptionKey: Output<String>
        get() = javaResource.encryptionKey().applyValue({ args0 -> args0 })

    /**
     * The AWS account ID that owns the domain.
     */
    public val owner: Output<String>
        get() = javaResource.owner().applyValue({ args0 -> args0 })

    /**
     * The number of repositories in the domain.
     */
    public val repositoryCount: Output<Int>
        get() = javaResource.repositoryCount().applyValue({ args0 -> args0 })

    /**
     * Key-value map of resource tags. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     */
    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })
}

public object DomainMapper : ResourceMapper<Domain> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.codeartifact.Domain::class == javaResource::class

    override fun map(javaResource: Resource): Domain = Domain(
        javaResource as
            com.pulumi.aws.codeartifact.Domain,
    )
}

/**
 * @see [Domain].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Domain].
 */
public suspend fun domain(name: String, block: suspend DomainResourceBuilder.() -> Unit): Domain {
    val builder = DomainResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Domain].
 * @param name The _unique_ name of the resulting resource.
 */
public fun domain(name: String): Domain {
    val builder = DomainResourceBuilder()
    builder.name(name)
    return builder.build()
}
