@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.codeartifact.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [DomainPermissions].
 */
@PulumiTagMarker
public class DomainPermissionsResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: DomainPermissionsArgs = DomainPermissionsArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend DomainPermissionsArgsBuilder.() -> Unit) {
        val builder = DomainPermissionsArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): DomainPermissions {
        val builtJavaResource = com.pulumi.aws.codeartifact.DomainPermissions(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return DomainPermissions(builtJavaResource)
    }
}

/**
 * Provides a CodeArtifact Domains Permissions Policy Resource.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.kms.Key;
 * import com.pulumi.aws.kms.KeyArgs;
 * import com.pulumi.aws.codeartifact.Domain;
 * import com.pulumi.aws.codeartifact.DomainArgs;
 * import com.pulumi.aws.iam.IamFunctions;
 * import com.pulumi.aws.iam.inputs.GetPolicyDocumentArgs;
 * import com.pulumi.aws.codeartifact.DomainPermissions;
 * import com.pulumi.aws.codeartifact.DomainPermissionsArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var exampleKey = new Key("exampleKey", KeyArgs.builder()
 *             .description("domain key")
 *             .build());
 *         var exampleDomain = new Domain("exampleDomain", DomainArgs.builder()
 *             .domain("example")
 *             .encryptionKey(exampleKey.arn())
 *             .build());
 *         final var testPolicyDocument = IamFunctions.getPolicyDocument(GetPolicyDocumentArgs.builder()
 *             .statements(GetPolicyDocumentStatementArgs.builder()
 *                 .effect("Allow")
 *                 .principals(GetPolicyDocumentStatementPrincipalArgs.builder()
 *                     .type("*")
 *                     .identifiers("*")
 *                     .build())
 *                 .actions("codeartifact:CreateRepository")
 *                 .resources(exampleDomain.arn())
 *                 .build())
 *             .build());
 *         var testDomainPermissions = new DomainPermissions("testDomainPermissions", DomainPermissionsArgs.builder()
 *             .domain(exampleDomain.domain())
 *             .policyDocument(testPolicyDocument.applyValue(getPolicyDocumentResult -> getPolicyDocumentResult).applyValue(testPolicyDocument -> testPolicyDocument.applyValue(getPolicyDocumentResult -> getPolicyDocumentResult.json())))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import CodeArtifact Domain Permissions Policies using the CodeArtifact Domain ARN. For example:
 * ```sh
 *  $ pulumi import aws:codeartifact/domainPermissions:DomainPermissions example arn:aws:codeartifact:us-west-2:012345678912:domain/tf-acc-test-1928056699409417367
 * ```
 *
 */
public class DomainPermissions internal constructor(
    override val javaResource: com.pulumi.aws.codeartifact.DomainPermissions,
) : KotlinCustomResource(javaResource, DomainPermissionsMapper) {
    /**
     * The name of the domain on which to set the resource policy.
     */
    public val domain: Output<String>
        get() = javaResource.domain().applyValue({ args0 -> args0 })

    /**
     * The account number of the AWS account that owns the domain.
     */
    public val domainOwner: Output<String>
        get() = javaResource.domainOwner().applyValue({ args0 -> args0 })

    /**
     * A JSON policy string to be set as the access control resource policy on the provided domain.
     */
    public val policyDocument: Output<String>
        get() = javaResource.policyDocument().applyValue({ args0 -> args0 })

    /**
     * The current revision of the resource policy to be set. This revision is used for optimistic locking, which prevents others from overwriting your changes to the domain's resource policy.
     */
    public val policyRevision: Output<String>
        get() = javaResource.policyRevision().applyValue({ args0 -> args0 })

    /**
     * The ARN of the resource associated with the resource policy.
     */
    public val resourceArn: Output<String>
        get() = javaResource.resourceArn().applyValue({ args0 -> args0 })
}

public object DomainPermissionsMapper : ResourceMapper<DomainPermissions> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.codeartifact.DomainPermissions::class == javaResource::class

    override fun map(javaResource: Resource): DomainPermissions = DomainPermissions(
        javaResource as
            com.pulumi.aws.codeartifact.DomainPermissions,
    )
}

/**
 * @see [DomainPermissions].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [DomainPermissions].
 */
public suspend fun domainPermissions(
    name: String,
    block: suspend DomainPermissionsResourceBuilder.() -> Unit,
): DomainPermissions {
    val builder = DomainPermissionsResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [DomainPermissions].
 * @param name The _unique_ name of the resulting resource.
 */
public fun domainPermissions(name: String): DomainPermissions {
    val builder = DomainPermissionsResourceBuilder()
    builder.name(name)
    return builder.build()
}
