@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.codeartifact.kotlin

import com.pulumi.aws.codeartifact.DomainPermissionsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Provides a CodeArtifact Domains Permissions Policy Resource.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.kms.Key;
 * import com.pulumi.aws.kms.KeyArgs;
 * import com.pulumi.aws.codeartifact.Domain;
 * import com.pulumi.aws.codeartifact.DomainArgs;
 * import com.pulumi.aws.iam.IamFunctions;
 * import com.pulumi.aws.iam.inputs.GetPolicyDocumentArgs;
 * import com.pulumi.aws.codeartifact.DomainPermissions;
 * import com.pulumi.aws.codeartifact.DomainPermissionsArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var exampleKey = new Key("exampleKey", KeyArgs.builder()
 *             .description("domain key")
 *             .build());
 *         var exampleDomain = new Domain("exampleDomain", DomainArgs.builder()
 *             .domain("example")
 *             .encryptionKey(exampleKey.arn())
 *             .build());
 *         final var testPolicyDocument = IamFunctions.getPolicyDocument(GetPolicyDocumentArgs.builder()
 *             .statements(GetPolicyDocumentStatementArgs.builder()
 *                 .effect("Allow")
 *                 .principals(GetPolicyDocumentStatementPrincipalArgs.builder()
 *                     .type("*")
 *                     .identifiers("*")
 *                     .build())
 *                 .actions("codeartifact:CreateRepository")
 *                 .resources(exampleDomain.arn())
 *                 .build())
 *             .build());
 *         var testDomainPermissions = new DomainPermissions("testDomainPermissions", DomainPermissionsArgs.builder()
 *             .domain(exampleDomain.domain())
 *             .policyDocument(testPolicyDocument.applyValue(getPolicyDocumentResult -> getPolicyDocumentResult).applyValue(testPolicyDocument -> testPolicyDocument.applyValue(getPolicyDocumentResult -> getPolicyDocumentResult.json())))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import CodeArtifact Domain Permissions Policies using the CodeArtifact Domain ARN. For example:
 * ```sh
 *  $ pulumi import aws:codeartifact/domainPermissions:DomainPermissions example arn:aws:codeartifact:us-west-2:012345678912:domain/tf-acc-test-1928056699409417367
 * ```
 * @property domain The name of the domain on which to set the resource policy.
 * @property domainOwner The account number of the AWS account that owns the domain.
 * @property policyDocument A JSON policy string to be set as the access control resource policy on the provided domain.
 * @property policyRevision The current revision of the resource policy to be set. This revision is used for optimistic locking, which prevents others from overwriting your changes to the domain's resource policy.
 */
public data class DomainPermissionsArgs(
    public val domain: Output<String>? = null,
    public val domainOwner: Output<String>? = null,
    public val policyDocument: Output<String>? = null,
    public val policyRevision: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.codeartifact.DomainPermissionsArgs> {
    override fun toJava(): com.pulumi.aws.codeartifact.DomainPermissionsArgs =
        com.pulumi.aws.codeartifact.DomainPermissionsArgs.builder()
            .domain(domain?.applyValue({ args0 -> args0 }))
            .domainOwner(domainOwner?.applyValue({ args0 -> args0 }))
            .policyDocument(policyDocument?.applyValue({ args0 -> args0 }))
            .policyRevision(policyRevision?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [DomainPermissionsArgs].
 */
@PulumiTagMarker
public class DomainPermissionsArgsBuilder internal constructor() {
    private var domain: Output<String>? = null

    private var domainOwner: Output<String>? = null

    private var policyDocument: Output<String>? = null

    private var policyRevision: Output<String>? = null

    /**
     * @param value The name of the domain on which to set the resource policy.
     */
    @JvmName("kwmoviuwuefqptab")
    public suspend fun domain(`value`: Output<String>) {
        this.domain = value
    }

    /**
     * @param value The account number of the AWS account that owns the domain.
     */
    @JvmName("mvjtbioqbevjlgrm")
    public suspend fun domainOwner(`value`: Output<String>) {
        this.domainOwner = value
    }

    /**
     * @param value A JSON policy string to be set as the access control resource policy on the provided domain.
     */
    @JvmName("eybiupqjsprnkqhk")
    public suspend fun policyDocument(`value`: Output<String>) {
        this.policyDocument = value
    }

    /**
     * @param value The current revision of the resource policy to be set. This revision is used for optimistic locking, which prevents others from overwriting your changes to the domain's resource policy.
     */
    @JvmName("rpqhfcunbvxswgec")
    public suspend fun policyRevision(`value`: Output<String>) {
        this.policyRevision = value
    }

    /**
     * @param value The name of the domain on which to set the resource policy.
     */
    @JvmName("pgrjuvjoqimxxeje")
    public suspend fun domain(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.domain = mapped
    }

    /**
     * @param value The account number of the AWS account that owns the domain.
     */
    @JvmName("ofktoqwymoysdnxk")
    public suspend fun domainOwner(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.domainOwner = mapped
    }

    /**
     * @param value A JSON policy string to be set as the access control resource policy on the provided domain.
     */
    @JvmName("xucpeqofnithasvt")
    public suspend fun policyDocument(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.policyDocument = mapped
    }

    /**
     * @param value The current revision of the resource policy to be set. This revision is used for optimistic locking, which prevents others from overwriting your changes to the domain's resource policy.
     */
    @JvmName("gilhwrtqerxibecq")
    public suspend fun policyRevision(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.policyRevision = mapped
    }

    internal fun build(): DomainPermissionsArgs = DomainPermissionsArgs(
        domain = domain,
        domainOwner = domainOwner,
        policyDocument = policyDocument,
        policyRevision = policyRevision,
    )
}
