@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.codeartifact.kotlin

import com.pulumi.aws.codeartifact.kotlin.outputs.RepositoryExternalConnections
import com.pulumi.aws.codeartifact.kotlin.outputs.RepositoryUpstream
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import com.pulumi.aws.codeartifact.kotlin.outputs.RepositoryExternalConnections.Companion.toKotlin as repositoryExternalConnectionsToKotlin
import com.pulumi.aws.codeartifact.kotlin.outputs.RepositoryUpstream.Companion.toKotlin as repositoryUpstreamToKotlin

/**
 * Builder for [Repository].
 */
@PulumiTagMarker
public class RepositoryResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: RepositoryArgs = RepositoryArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend RepositoryArgsBuilder.() -> Unit) {
        val builder = RepositoryArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): Repository {
        val builtJavaResource = com.pulumi.aws.codeartifact.Repository(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Repository(builtJavaResource)
    }
}

/**
 * Provides a CodeArtifact Repository Resource.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.kms.Key;
 * import com.pulumi.aws.kms.KeyArgs;
 * import com.pulumi.aws.codeartifact.Domain;
 * import com.pulumi.aws.codeartifact.DomainArgs;
 * import com.pulumi.aws.codeartifact.Repository;
 * import com.pulumi.aws.codeartifact.RepositoryArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var exampleKey = new Key("exampleKey", KeyArgs.builder()
 *             .description("domain key")
 *             .build());
 *         var exampleDomain = new Domain("exampleDomain", DomainArgs.builder()
 *             .domain("example")
 *             .encryptionKey(exampleKey.arn())
 *             .build());
 *         var test = new Repository("test", RepositoryArgs.builder()
 *             .repository("example")
 *             .domain(exampleDomain.domain())
 *             .build());
 *     }
 * }
 * ```
 * ### With Upstream Repository
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.codeartifact.Repository;
 * import com.pulumi.aws.codeartifact.RepositoryArgs;
 * import com.pulumi.aws.codeartifact.inputs.RepositoryUpstreamArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var upstream = new Repository("upstream", RepositoryArgs.builder()
 *             .repository("upstream")
 *             .domain(aws_codeartifact_domain.test().domain())
 *             .build());
 *         var test = new Repository("test", RepositoryArgs.builder()
 *             .repository("example")
 *             .domain(aws_codeartifact_domain.example().domain())
 *             .upstreams(RepositoryUpstreamArgs.builder()
 *                 .repositoryName(upstream.repository())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ### With External Connection
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.codeartifact.Repository;
 * import com.pulumi.aws.codeartifact.RepositoryArgs;
 * import com.pulumi.aws.codeartifact.inputs.RepositoryExternalConnectionsArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var upstream = new Repository("upstream", RepositoryArgs.builder()
 *             .repository("upstream")
 *             .domain(aws_codeartifact_domain.test().domain())
 *             .build());
 *         var test = new Repository("test", RepositoryArgs.builder()
 *             .repository("example")
 *             .domain(aws_codeartifact_domain.example().domain())
 *             .externalConnections(RepositoryExternalConnectionsArgs.builder()
 *                 .externalConnectionName("public:npmjs")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import CodeArtifact Repository using the CodeArtifact Repository ARN. For example:
 * ```sh
 *  $ pulumi import aws:codeartifact/repository:Repository example arn:aws:codeartifact:us-west-2:012345678912:repository/tf-acc-test-6968272603913957763/tf-acc-test-6968272603913957763
 * ```
 *
 */
public class Repository internal constructor(
    override val javaResource: com.pulumi.aws.codeartifact.Repository,
) : KotlinCustomResource(javaResource, RepositoryMapper) {
    /**
     * The account number of the AWS account that manages the repository.
     */
    public val administratorAccount: Output<String>
        get() = javaResource.administratorAccount().applyValue({ args0 -> args0 })

    /**
     * The ARN of the repository.
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * The description of the repository.
     */
    public val description: Output<String>?
        get() = javaResource.description().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The domain that contains the created repository.
     */
    public val domain: Output<String>
        get() = javaResource.domain().applyValue({ args0 -> args0 })

    /**
     * The account number of the AWS account that owns the domain.
     */
    public val domainOwner: Output<String>
        get() = javaResource.domainOwner().applyValue({ args0 -> args0 })

    /**
     * An array of external connections associated with the repository. Only one external connection can be set per repository. see External Connections.
     */
    public val externalConnections: Output<RepositoryExternalConnections>?
        get() = javaResource.externalConnections().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> repositoryExternalConnectionsToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * The name of the repository to create.
     */
    public val repository: Output<String>
        get() = javaResource.repository().applyValue({ args0 -> args0 })

    /**
     * Key-value map of resource tags. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     */
    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })

    /**
     * A list of upstream repositories to associate with the repository. The order of the upstream repositories in the list determines their priority order when AWS CodeArtifact looks for a requested package version. see Upstream
     */
    public val upstreams: Output<List<RepositoryUpstream>>?
        get() = javaResource.upstreams().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 -> repositoryUpstreamToKotlin(args0) })
                })
            }).orElse(null)
        })
}

public object RepositoryMapper : ResourceMapper<Repository> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.codeartifact.Repository::class == javaResource::class

    override fun map(javaResource: Resource): Repository = Repository(
        javaResource as
            com.pulumi.aws.codeartifact.Repository,
    )
}

/**
 * @see [Repository].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Repository].
 */
public suspend fun repository(name: String, block: suspend RepositoryResourceBuilder.() -> Unit):
    Repository {
    val builder = RepositoryResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Repository].
 * @param name The _unique_ name of the resulting resource.
 */
public fun repository(name: String): Repository {
    val builder = RepositoryResourceBuilder()
    builder.name(name)
    return builder.build()
}
