@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.codeartifact.kotlin

import com.pulumi.aws.codeartifact.RepositoryArgs.builder
import com.pulumi.aws.codeartifact.kotlin.inputs.RepositoryExternalConnectionsArgs
import com.pulumi.aws.codeartifact.kotlin.inputs.RepositoryExternalConnectionsArgsBuilder
import com.pulumi.aws.codeartifact.kotlin.inputs.RepositoryUpstreamArgs
import com.pulumi.aws.codeartifact.kotlin.inputs.RepositoryUpstreamArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Provides a CodeArtifact Repository Resource.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.kms.Key;
 * import com.pulumi.aws.kms.KeyArgs;
 * import com.pulumi.aws.codeartifact.Domain;
 * import com.pulumi.aws.codeartifact.DomainArgs;
 * import com.pulumi.aws.codeartifact.Repository;
 * import com.pulumi.aws.codeartifact.RepositoryArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var exampleKey = new Key("exampleKey", KeyArgs.builder()
 *             .description("domain key")
 *             .build());
 *         var exampleDomain = new Domain("exampleDomain", DomainArgs.builder()
 *             .domain("example")
 *             .encryptionKey(exampleKey.arn())
 *             .build());
 *         var test = new Repository("test", RepositoryArgs.builder()
 *             .repository("example")
 *             .domain(exampleDomain.domain())
 *             .build());
 *     }
 * }
 * ```
 * ### With Upstream Repository
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.codeartifact.Repository;
 * import com.pulumi.aws.codeartifact.RepositoryArgs;
 * import com.pulumi.aws.codeartifact.inputs.RepositoryUpstreamArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var upstream = new Repository("upstream", RepositoryArgs.builder()
 *             .repository("upstream")
 *             .domain(aws_codeartifact_domain.test().domain())
 *             .build());
 *         var test = new Repository("test", RepositoryArgs.builder()
 *             .repository("example")
 *             .domain(aws_codeartifact_domain.example().domain())
 *             .upstreams(RepositoryUpstreamArgs.builder()
 *                 .repositoryName(upstream.repository())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ### With External Connection
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.codeartifact.Repository;
 * import com.pulumi.aws.codeartifact.RepositoryArgs;
 * import com.pulumi.aws.codeartifact.inputs.RepositoryExternalConnectionsArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var upstream = new Repository("upstream", RepositoryArgs.builder()
 *             .repository("upstream")
 *             .domain(aws_codeartifact_domain.test().domain())
 *             .build());
 *         var test = new Repository("test", RepositoryArgs.builder()
 *             .repository("example")
 *             .domain(aws_codeartifact_domain.example().domain())
 *             .externalConnections(RepositoryExternalConnectionsArgs.builder()
 *                 .externalConnectionName("public:npmjs")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import CodeArtifact Repository using the CodeArtifact Repository ARN. For example:
 * ```sh
 *  $ pulumi import aws:codeartifact/repository:Repository example arn:aws:codeartifact:us-west-2:012345678912:repository/tf-acc-test-6968272603913957763/tf-acc-test-6968272603913957763
 * ```
 * @property description The description of the repository.
 * @property domain The domain that contains the created repository.
 * @property domainOwner The account number of the AWS account that owns the domain.
 * @property externalConnections An array of external connections associated with the repository. Only one external connection can be set per repository. see External Connections.
 * @property repository The name of the repository to create.
 * @property tags Key-value map of resource tags. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 * @property upstreams A list of upstream repositories to associate with the repository. The order of the upstream repositories in the list determines their priority order when AWS CodeArtifact looks for a requested package version. see Upstream
 */
public data class RepositoryArgs(
    public val description: Output<String>? = null,
    public val domain: Output<String>? = null,
    public val domainOwner: Output<String>? = null,
    public val externalConnections: Output<RepositoryExternalConnectionsArgs>? = null,
    public val repository: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val upstreams: Output<List<RepositoryUpstreamArgs>>? = null,
) : ConvertibleToJava<com.pulumi.aws.codeartifact.RepositoryArgs> {
    override fun toJava(): com.pulumi.aws.codeartifact.RepositoryArgs =
        com.pulumi.aws.codeartifact.RepositoryArgs.builder()
            .description(description?.applyValue({ args0 -> args0 }))
            .domain(domain?.applyValue({ args0 -> args0 }))
            .domainOwner(domainOwner?.applyValue({ args0 -> args0 }))
            .externalConnections(
                externalConnections?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .repository(repository?.applyValue({ args0 -> args0 }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .upstreams(
                upstreams?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [RepositoryArgs].
 */
@PulumiTagMarker
public class RepositoryArgsBuilder internal constructor() {
    private var description: Output<String>? = null

    private var domain: Output<String>? = null

    private var domainOwner: Output<String>? = null

    private var externalConnections: Output<RepositoryExternalConnectionsArgs>? = null

    private var repository: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    private var upstreams: Output<List<RepositoryUpstreamArgs>>? = null

    /**
     * @param value The description of the repository.
     */
    @JvmName("eohvujpmowmainff")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value The domain that contains the created repository.
     */
    @JvmName("anckdixrctqkkcxl")
    public suspend fun domain(`value`: Output<String>) {
        this.domain = value
    }

    /**
     * @param value The account number of the AWS account that owns the domain.
     */
    @JvmName("aedeerrbxfstbnfq")
    public suspend fun domainOwner(`value`: Output<String>) {
        this.domainOwner = value
    }

    /**
     * @param value An array of external connections associated with the repository. Only one external connection can be set per repository. see External Connections.
     */
    @JvmName("jbioodaondcdtvpb")
    public suspend fun externalConnections(`value`: Output<RepositoryExternalConnectionsArgs>) {
        this.externalConnections = value
    }

    /**
     * @param value The name of the repository to create.
     */
    @JvmName("syrkpgvlkbddjsjm")
    public suspend fun repository(`value`: Output<String>) {
        this.repository = value
    }

    /**
     * @param value Key-value map of resource tags. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("wuecuxvlymftknps")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value A list of upstream repositories to associate with the repository. The order of the upstream repositories in the list determines their priority order when AWS CodeArtifact looks for a requested package version. see Upstream
     */
    @JvmName("tonjfeeidhlovfoj")
    public suspend fun upstreams(`value`: Output<List<RepositoryUpstreamArgs>>) {
        this.upstreams = value
    }

    @JvmName("xrsypsiqkykpyobe")
    public suspend fun upstreams(vararg values: Output<RepositoryUpstreamArgs>) {
        this.upstreams = Output.all(values.asList())
    }

    /**
     * @param values A list of upstream repositories to associate with the repository. The order of the upstream repositories in the list determines their priority order when AWS CodeArtifact looks for a requested package version. see Upstream
     */
    @JvmName("ovwtuiunavultauu")
    public suspend fun upstreams(values: List<Output<RepositoryUpstreamArgs>>) {
        this.upstreams = Output.all(values)
    }

    /**
     * @param value The description of the repository.
     */
    @JvmName("khkvhdqglfnwbchb")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value The domain that contains the created repository.
     */
    @JvmName("hungdrevklumpiip")
    public suspend fun domain(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.domain = mapped
    }

    /**
     * @param value The account number of the AWS account that owns the domain.
     */
    @JvmName("ycgbeyrbonucqmwl")
    public suspend fun domainOwner(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.domainOwner = mapped
    }

    /**
     * @param value An array of external connections associated with the repository. Only one external connection can be set per repository. see External Connections.
     */
    @JvmName("gdqnbiqfxpuypquj")
    public suspend fun externalConnections(`value`: RepositoryExternalConnectionsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.externalConnections = mapped
    }

    /**
     * @param argument An array of external connections associated with the repository. Only one external connection can be set per repository. see External Connections.
     */
    @JvmName("uqjvmetyjdwwvpku")
    public suspend
    fun externalConnections(argument: suspend RepositoryExternalConnectionsArgsBuilder.() -> Unit) {
        val toBeMapped = RepositoryExternalConnectionsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.externalConnections = mapped
    }

    /**
     * @param value The name of the repository to create.
     */
    @JvmName("ewxwxuseugxolwkm")
    public suspend fun repository(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.repository = mapped
    }

    /**
     * @param value Key-value map of resource tags. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("vuqnxpkmnfikfdqc")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Key-value map of resource tags. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("khxsrtoljveivdfl")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value A list of upstream repositories to associate with the repository. The order of the upstream repositories in the list determines their priority order when AWS CodeArtifact looks for a requested package version. see Upstream
     */
    @JvmName("ibbuuckeblbchgya")
    public suspend fun upstreams(`value`: List<RepositoryUpstreamArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.upstreams = mapped
    }

    /**
     * @param argument A list of upstream repositories to associate with the repository. The order of the upstream repositories in the list determines their priority order when AWS CodeArtifact looks for a requested package version. see Upstream
     */
    @JvmName("iebwvjronkvhxeod")
    public suspend fun upstreams(argument: List<suspend RepositoryUpstreamArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            RepositoryUpstreamArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.upstreams = mapped
    }

    /**
     * @param argument A list of upstream repositories to associate with the repository. The order of the upstream repositories in the list determines their priority order when AWS CodeArtifact looks for a requested package version. see Upstream
     */
    @JvmName("wovuajibbmfofbim")
    public suspend fun upstreams(vararg argument: suspend RepositoryUpstreamArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            RepositoryUpstreamArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.upstreams = mapped
    }

    /**
     * @param argument A list of upstream repositories to associate with the repository. The order of the upstream repositories in the list determines their priority order when AWS CodeArtifact looks for a requested package version. see Upstream
     */
    @JvmName("acxniqysroojugmd")
    public suspend fun upstreams(argument: suspend RepositoryUpstreamArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(RepositoryUpstreamArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.upstreams = mapped
    }

    /**
     * @param values A list of upstream repositories to associate with the repository. The order of the upstream repositories in the list determines their priority order when AWS CodeArtifact looks for a requested package version. see Upstream
     */
    @JvmName("wtyangjrgcrmbnha")
    public suspend fun upstreams(vararg values: RepositoryUpstreamArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.upstreams = mapped
    }

    internal fun build(): RepositoryArgs = RepositoryArgs(
        description = description,
        domain = domain,
        domainOwner = domainOwner,
        externalConnections = externalConnections,
        repository = repository,
        tags = tags,
        upstreams = upstreams,
    )
}
