@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.codeartifact.kotlin

import com.pulumi.aws.codeartifact.RepositoryPermissionsPolicyArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Provides a CodeArtifact Repostory Permissions Policy Resource.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.kms.Key;
 * import com.pulumi.aws.kms.KeyArgs;
 * import com.pulumi.aws.codeartifact.Domain;
 * import com.pulumi.aws.codeartifact.DomainArgs;
 * import com.pulumi.aws.codeartifact.Repository;
 * import com.pulumi.aws.codeartifact.RepositoryArgs;
 * import com.pulumi.aws.iam.IamFunctions;
 * import com.pulumi.aws.iam.inputs.GetPolicyDocumentArgs;
 * import com.pulumi.aws.codeartifact.RepositoryPermissionsPolicy;
 * import com.pulumi.aws.codeartifact.RepositoryPermissionsPolicyArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var exampleKey = new Key("exampleKey", KeyArgs.builder()
 *             .description("domain key")
 *             .build());
 *         var exampleDomain = new Domain("exampleDomain", DomainArgs.builder()
 *             .domain("example")
 *             .encryptionKey(exampleKey.arn())
 *             .build());
 *         var exampleRepository = new Repository("exampleRepository", RepositoryArgs.builder()
 *             .repository("example")
 *             .domain(exampleDomain.domain())
 *             .build());
 *         final var examplePolicyDocument = IamFunctions.getPolicyDocument(GetPolicyDocumentArgs.builder()
 *             .statements(GetPolicyDocumentStatementArgs.builder()
 *                 .effect("Allow")
 *                 .principals(GetPolicyDocumentStatementPrincipalArgs.builder()
 *                     .type("*")
 *                     .identifiers("*")
 *                     .build())
 *                 .actions("codeartifact:ReadFromRepository")
 *                 .resources(exampleRepository.arn())
 *                 .build())
 *             .build());
 *         var exampleRepositoryPermissionsPolicy = new RepositoryPermissionsPolicy("exampleRepositoryPermissionsPolicy", RepositoryPermissionsPolicyArgs.builder()
 *             .repository(exampleRepository.repository())
 *             .domain(exampleDomain.domain())
 *             .policyDocument(examplePolicyDocument.applyValue(getPolicyDocumentResult -> getPolicyDocumentResult).applyValue(examplePolicyDocument -> examplePolicyDocument.applyValue(getPolicyDocumentResult -> getPolicyDocumentResult.json())))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import CodeArtifact Repository Permissions Policies using the CodeArtifact Repository ARN. For example:
 * ```sh
 *  $ pulumi import aws:codeartifact/repositoryPermissionsPolicy:RepositoryPermissionsPolicy example arn:aws:codeartifact:us-west-2:012345678912:repository/tf-acc-test-6968272603913957763/tf-acc-test-6968272603913957763
 * ```
 * @property domain The name of the domain on which to set the resource policy.
 * @property domainOwner The account number of the AWS account that owns the domain.
 * @property policyDocument A JSON policy string to be set as the access control resource policy on the provided domain.
 * @property policyRevision The current revision of the resource policy to be set. This revision is used for optimistic locking, which prevents others from overwriting your changes to the domain's resource policy.
 * @property repository The name of the repository to set the resource policy on.
 */
public data class RepositoryPermissionsPolicyArgs(
    public val domain: Output<String>? = null,
    public val domainOwner: Output<String>? = null,
    public val policyDocument: Output<String>? = null,
    public val policyRevision: Output<String>? = null,
    public val repository: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.codeartifact.RepositoryPermissionsPolicyArgs> {
    override fun toJava(): com.pulumi.aws.codeartifact.RepositoryPermissionsPolicyArgs =
        com.pulumi.aws.codeartifact.RepositoryPermissionsPolicyArgs.builder()
            .domain(domain?.applyValue({ args0 -> args0 }))
            .domainOwner(domainOwner?.applyValue({ args0 -> args0 }))
            .policyDocument(policyDocument?.applyValue({ args0 -> args0 }))
            .policyRevision(policyRevision?.applyValue({ args0 -> args0 }))
            .repository(repository?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [RepositoryPermissionsPolicyArgs].
 */
@PulumiTagMarker
public class RepositoryPermissionsPolicyArgsBuilder internal constructor() {
    private var domain: Output<String>? = null

    private var domainOwner: Output<String>? = null

    private var policyDocument: Output<String>? = null

    private var policyRevision: Output<String>? = null

    private var repository: Output<String>? = null

    /**
     * @param value The name of the domain on which to set the resource policy.
     */
    @JvmName("qpfwcwyqgmchotyn")
    public suspend fun domain(`value`: Output<String>) {
        this.domain = value
    }

    /**
     * @param value The account number of the AWS account that owns the domain.
     */
    @JvmName("ceehfxgdbeearvbt")
    public suspend fun domainOwner(`value`: Output<String>) {
        this.domainOwner = value
    }

    /**
     * @param value A JSON policy string to be set as the access control resource policy on the provided domain.
     */
    @JvmName("aoncsubcrhavcbvp")
    public suspend fun policyDocument(`value`: Output<String>) {
        this.policyDocument = value
    }

    /**
     * @param value The current revision of the resource policy to be set. This revision is used for optimistic locking, which prevents others from overwriting your changes to the domain's resource policy.
     */
    @JvmName("cwtyvxqhatjqpota")
    public suspend fun policyRevision(`value`: Output<String>) {
        this.policyRevision = value
    }

    /**
     * @param value The name of the repository to set the resource policy on.
     */
    @JvmName("rxemxkwygquynnjf")
    public suspend fun repository(`value`: Output<String>) {
        this.repository = value
    }

    /**
     * @param value The name of the domain on which to set the resource policy.
     */
    @JvmName("mmlycxhwlyyrfmjv")
    public suspend fun domain(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.domain = mapped
    }

    /**
     * @param value The account number of the AWS account that owns the domain.
     */
    @JvmName("yepowptvvuawoups")
    public suspend fun domainOwner(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.domainOwner = mapped
    }

    /**
     * @param value A JSON policy string to be set as the access control resource policy on the provided domain.
     */
    @JvmName("cwhvixuhtpcjrvuq")
    public suspend fun policyDocument(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.policyDocument = mapped
    }

    /**
     * @param value The current revision of the resource policy to be set. This revision is used for optimistic locking, which prevents others from overwriting your changes to the domain's resource policy.
     */
    @JvmName("geoobvaoonlijeva")
    public suspend fun policyRevision(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.policyRevision = mapped
    }

    /**
     * @param value The name of the repository to set the resource policy on.
     */
    @JvmName("urkdcqnbtcimjcue")
    public suspend fun repository(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.repository = mapped
    }

    internal fun build(): RepositoryPermissionsPolicyArgs = RepositoryPermissionsPolicyArgs(
        domain = domain,
        domainOwner = domainOwner,
        policyDocument = policyDocument,
        policyRevision = policyRevision,
        repository = repository,
    )
}
