@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.codeartifact.kotlin.inputs

import com.pulumi.aws.codeartifact.inputs.GetRepositoryEndpointPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getRepositoryEndpoint.
 * @property domain Name of the domain that contains the repository.
 * @property domainOwner Account number of the AWS account that owns the domain.
 * @property format Which endpoint of a repository to return. A repository has one endpoint for each package format: `npm`, `pypi`, `maven`, and `nuget`.
 * @property repository Name of the repository.
 */
public data class GetRepositoryEndpointPlainArgs(
    public val domain: String,
    public val domainOwner: String? = null,
    public val format: String,
    public val repository: String,
) : ConvertibleToJava<com.pulumi.aws.codeartifact.inputs.GetRepositoryEndpointPlainArgs> {
    override fun toJava(): com.pulumi.aws.codeartifact.inputs.GetRepositoryEndpointPlainArgs =
        com.pulumi.aws.codeartifact.inputs.GetRepositoryEndpointPlainArgs.builder()
            .domain(domain.let({ args0 -> args0 }))
            .domainOwner(domainOwner?.let({ args0 -> args0 }))
            .format(format.let({ args0 -> args0 }))
            .repository(repository.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetRepositoryEndpointPlainArgs].
 */
@PulumiTagMarker
public class GetRepositoryEndpointPlainArgsBuilder internal constructor() {
    private var domain: String? = null

    private var domainOwner: String? = null

    private var format: String? = null

    private var repository: String? = null

    /**
     * @param value Name of the domain that contains the repository.
     */
    @JvmName("npfcrpbglabgwrgu")
    public suspend fun domain(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.domain = mapped
    }

    /**
     * @param value Account number of the AWS account that owns the domain.
     */
    @JvmName("yjibcrnxmqqnxhrx")
    public suspend fun domainOwner(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.domainOwner = mapped
    }

    /**
     * @param value Which endpoint of a repository to return. A repository has one endpoint for each package format: `npm`, `pypi`, `maven`, and `nuget`.
     */
    @JvmName("yhqckhusstiolvha")
    public suspend fun format(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.format = mapped
    }

    /**
     * @param value Name of the repository.
     */
    @JvmName("pesxsjmtgojfeocd")
    public suspend fun repository(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.repository = mapped
    }

    internal fun build(): GetRepositoryEndpointPlainArgs = GetRepositoryEndpointPlainArgs(
        domain = domain ?: throw PulumiNullFieldException("domain"),
        domainOwner = domainOwner,
        format = format ?: throw PulumiNullFieldException("format"),
        repository = repository ?: throw PulumiNullFieldException("repository"),
    )
}
