@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.codeartifact.kotlin.inputs

import com.pulumi.aws.codeartifact.inputs.RepositoryUpstreamArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property repositoryName The name of an upstream repository.
 */
public data class RepositoryUpstreamArgs(
    public val repositoryName: Output<String>,
) : ConvertibleToJava<com.pulumi.aws.codeartifact.inputs.RepositoryUpstreamArgs> {
    override fun toJava(): com.pulumi.aws.codeartifact.inputs.RepositoryUpstreamArgs =
        com.pulumi.aws.codeartifact.inputs.RepositoryUpstreamArgs.builder()
            .repositoryName(repositoryName.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [RepositoryUpstreamArgs].
 */
@PulumiTagMarker
public class RepositoryUpstreamArgsBuilder internal constructor() {
    private var repositoryName: Output<String>? = null

    /**
     * @param value The name of an upstream repository.
     */
    @JvmName("dbgyrbdhxuxqsldw")
    public suspend fun repositoryName(`value`: Output<String>) {
        this.repositoryName = value
    }

    /**
     * @param value The name of an upstream repository.
     */
    @JvmName("eiegruhqqmxeccrp")
    public suspend fun repositoryName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.repositoryName = mapped
    }

    internal fun build(): RepositoryUpstreamArgs = RepositoryUpstreamArgs(
        repositoryName = repositoryName ?: throw PulumiNullFieldException("repositoryName"),
    )
}
