@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.codeartifact.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 * A collection of values returned by getAuthorizationToken.
 * @property authorizationToken Temporary authorization token.
 * @property domain
 * @property domainOwner
 * @property durationSeconds
 * @property expiration Time in UTC RFC3339 format when the authorization token expires.
 * @property id The provider-assigned unique ID for this managed resource.
 */
public data class GetAuthorizationTokenResult(
    public val authorizationToken: String,
    public val domain: String,
    public val domainOwner: String,
    public val durationSeconds: Int? = null,
    public val expiration: String,
    public val id: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.codeartifact.outputs.GetAuthorizationTokenResult):
            GetAuthorizationTokenResult = GetAuthorizationTokenResult(
            authorizationToken = javaType.authorizationToken(),
            domain = javaType.domain(),
            domainOwner = javaType.domainOwner(),
            durationSeconds = javaType.durationSeconds().map({ args0 -> args0 }).orElse(null),
            expiration = javaType.expiration(),
            id = javaType.id(),
        )
    }
}
