@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.codebuild.kotlin

import com.pulumi.aws.codebuild.kotlin.outputs.ProjectArtifacts
import com.pulumi.aws.codebuild.kotlin.outputs.ProjectBuildBatchConfig
import com.pulumi.aws.codebuild.kotlin.outputs.ProjectCache
import com.pulumi.aws.codebuild.kotlin.outputs.ProjectEnvironment
import com.pulumi.aws.codebuild.kotlin.outputs.ProjectFileSystemLocation
import com.pulumi.aws.codebuild.kotlin.outputs.ProjectLogsConfig
import com.pulumi.aws.codebuild.kotlin.outputs.ProjectSecondaryArtifact
import com.pulumi.aws.codebuild.kotlin.outputs.ProjectSecondarySource
import com.pulumi.aws.codebuild.kotlin.outputs.ProjectSecondarySourceVersion
import com.pulumi.aws.codebuild.kotlin.outputs.ProjectSource
import com.pulumi.aws.codebuild.kotlin.outputs.ProjectVpcConfig
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import com.pulumi.aws.codebuild.kotlin.outputs.ProjectArtifacts.Companion.toKotlin as projectArtifactsToKotlin
import com.pulumi.aws.codebuild.kotlin.outputs.ProjectBuildBatchConfig.Companion.toKotlin as projectBuildBatchConfigToKotlin
import com.pulumi.aws.codebuild.kotlin.outputs.ProjectCache.Companion.toKotlin as projectCacheToKotlin
import com.pulumi.aws.codebuild.kotlin.outputs.ProjectEnvironment.Companion.toKotlin as projectEnvironmentToKotlin
import com.pulumi.aws.codebuild.kotlin.outputs.ProjectFileSystemLocation.Companion.toKotlin as projectFileSystemLocationToKotlin
import com.pulumi.aws.codebuild.kotlin.outputs.ProjectLogsConfig.Companion.toKotlin as projectLogsConfigToKotlin
import com.pulumi.aws.codebuild.kotlin.outputs.ProjectSecondaryArtifact.Companion.toKotlin as projectSecondaryArtifactToKotlin
import com.pulumi.aws.codebuild.kotlin.outputs.ProjectSecondarySource.Companion.toKotlin as projectSecondarySourceToKotlin
import com.pulumi.aws.codebuild.kotlin.outputs.ProjectSecondarySourceVersion.Companion.toKotlin as projectSecondarySourceVersionToKotlin
import com.pulumi.aws.codebuild.kotlin.outputs.ProjectSource.Companion.toKotlin as projectSourceToKotlin
import com.pulumi.aws.codebuild.kotlin.outputs.ProjectVpcConfig.Companion.toKotlin as projectVpcConfigToKotlin

/**
 * Builder for [Project].
 */
@PulumiTagMarker
public class ProjectResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ProjectArgs = ProjectArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ProjectArgsBuilder.() -> Unit) {
        val builder = ProjectArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): Project {
        val builtJavaResource = com.pulumi.aws.codebuild.Project(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Project(builtJavaResource)
    }
}

/**
 * Provides a CodeBuild Project resource. See also the `aws.codebuild.Webhook` resource, which manages the webhook to the source (e.g., the "rebuild every time a code change is pushed" option in the CodeBuild web console).
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.s3.BucketV2;
 * import com.pulumi.aws.s3.BucketAclV2;
 * import com.pulumi.aws.s3.BucketAclV2Args;
 * import com.pulumi.aws.iam.IamFunctions;
 * import com.pulumi.aws.iam.inputs.GetPolicyDocumentArgs;
 * import com.pulumi.aws.iam.Role;
 * import com.pulumi.aws.iam.RoleArgs;
 * import com.pulumi.aws.iam.RolePolicy;
 * import com.pulumi.aws.iam.RolePolicyArgs;
 * import com.pulumi.aws.codebuild.Project;
 * import com.pulumi.aws.codebuild.ProjectArgs;
 * import com.pulumi.aws.codebuild.inputs.ProjectArtifactsArgs;
 * import com.pulumi.aws.codebuild.inputs.ProjectCacheArgs;
 * import com.pulumi.aws.codebuild.inputs.ProjectEnvironmentArgs;
 * import com.pulumi.aws.codebuild.inputs.ProjectLogsConfigArgs;
 * import com.pulumi.aws.codebuild.inputs.ProjectLogsConfigCloudwatchLogsArgs;
 * import com.pulumi.aws.codebuild.inputs.ProjectLogsConfigS3LogsArgs;
 * import com.pulumi.aws.codebuild.inputs.ProjectSourceArgs;
 * import com.pulumi.aws.codebuild.inputs.ProjectSourceGitSubmodulesConfigArgs;
 * import com.pulumi.aws.codebuild.inputs.ProjectVpcConfigArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var exampleBucketV2 = new BucketV2("exampleBucketV2");
 *         var exampleBucketAclV2 = new BucketAclV2("exampleBucketAclV2", BucketAclV2Args.builder()
 *             .bucket(exampleBucketV2.id())
 *             .acl("private")
 *             .build());
 *         final var assumeRole = IamFunctions.getPolicyDocument(GetPolicyDocumentArgs.builder()
 *             .statements(GetPolicyDocumentStatementArgs.builder()
 *                 .effect("Allow")
 *                 .principals(GetPolicyDocumentStatementPrincipalArgs.builder()
 *                     .type("Service")
 *                     .identifiers("codebuild.amazonaws.com")
 *                     .build())
 *                 .actions("sts:AssumeRole")
 *                 .build())
 *             .build());
 *         var exampleRole = new Role("exampleRole", RoleArgs.builder()
 *             .assumeRolePolicy(assumeRole.applyValue(getPolicyDocumentResult -> getPolicyDocumentResult.json()))
 *             .build());
 *         final var examplePolicyDocument = IamFunctions.getPolicyDocument(GetPolicyDocumentArgs.builder()
 *             .statements(
 *                 GetPolicyDocumentStatementArgs.builder()
 *                     .effect("Allow")
 *                     .actions(
 *                         "logs:CreateLogGroup",
 *                         "logs:CreateLogStream",
 *                         "logs:PutLogEvents")
 *                     .resources("*")
 *                     .build(),
 *                 GetPolicyDocumentStatementArgs.builder()
 *                     .effect("Allow")
 *                     .actions(
 *                         "ec2:CreateNetworkInterface",
 *                         "ec2:DescribeDhcpOptions",
 *                         "ec2:DescribeNetworkInterfaces",
 *                         "ec2:DeleteNetworkInterface",
 *                         "ec2:DescribeSubnets",
 *                         "ec2:DescribeSecurityGroups",
 *                         "ec2:DescribeVpcs")
 *                     .resources("*")
 *                     .build(),
 *                 GetPolicyDocumentStatementArgs.builder()
 *                     .effect("Allow")
 *                     .actions("ec2:CreateNetworkInterfacePermission")
 *                     .resources("arn:aws:ec2:us-east-1:123456789012:network-interface/*")
 *                     .conditions(
 *                         GetPolicyDocumentStatementConditionArgs.builder()
 *                             .test("StringEquals")
 *                             .variable("ec2:Subnet")
 *                             .values(
 *                                 aws_subnet.example1().arn(),
 *                                 aws_subnet.example2().arn())
 *                             .build(),
 *                         GetPolicyDocumentStatementConditionArgs.builder()
 *                             .test("StringEquals")
 *                             .variable("ec2:AuthorizedService")
 *                             .values("codebuild.amazonaws.com")
 *                             .build())
 *                     .build(),
 *                 GetPolicyDocumentStatementArgs.builder()
 *                     .effect("Allow")
 *                     .actions("s3:*")
 *                     .resources(
 *                         exampleBucketV2.arn(),
 *                         exampleBucketV2.arn().applyValue(arn -> String.format("%s/*", arn)))
 *                     .build())
 *             .build());
 *         var exampleRolePolicy = new RolePolicy("exampleRolePolicy", RolePolicyArgs.builder()
 *             .role(exampleRole.name())
 *             .policy(examplePolicyDocument.applyValue(getPolicyDocumentResult -> getPolicyDocumentResult).applyValue(examplePolicyDocument -> examplePolicyDocument.applyValue(getPolicyDocumentResult -> getPolicyDocumentResult.json())))
 *             .build());
 *         var exampleProject = new Project("exampleProject", ProjectArgs.builder()
 *             .description("test_codebuild_project")
 *             .buildTimeout(5)
 *             .serviceRole(exampleRole.arn())
 *             .artifacts(ProjectArtifactsArgs.builder()
 *                 .type("NO_ARTIFACTS")
 *                 .build())
 *             .cache(ProjectCacheArgs.builder()
 *                 .type("S3")
 *                 .location(exampleBucketV2.bucket())
 *                 .build())
 *             .environment(ProjectEnvironmentArgs.builder()
 *                 .computeType("BUILD_GENERAL1_SMALL")
 *                 .image("aws/codebuild/amazonlinux2-x86_64-standard:4.0")
 *                 .type("LINUX_CONTAINER")
 *                 .imagePullCredentialsType("CODEBUILD")
 *                 .environmentVariables(
 *                     ProjectEnvironmentEnvironmentVariableArgs.builder()
 *                         .name("SOME_KEY1")
 *                         .value("SOME_VALUE1")
 *                         .build(),
 *                     ProjectEnvironmentEnvironmentVariableArgs.builder()
 *                         .name("SOME_KEY2")
 *                         .value("SOME_VALUE2")
 *                         .type("PARAMETER_STORE")
 *                         .build())
 *                 .build())
 *             .logsConfig(ProjectLogsConfigArgs.builder()
 *                 .cloudwatchLogs(ProjectLogsConfigCloudwatchLogsArgs.builder()
 *                     .groupName("log-group")
 *                     .streamName("log-stream")
 *                     .build())
 *                 .s3Logs(ProjectLogsConfigS3LogsArgs.builder()
 *                     .status("ENABLED")
 *                     .location(exampleBucketV2.id().applyValue(id -> String.format("%s/build-log", id)))
 *                     .build())
 *                 .build())
 *             .source(ProjectSourceArgs.builder()
 *                 .type("GITHUB")
 *                 .location("https://github.com/mitchellh/packer.git")
 *                 .gitCloneDepth(1)
 *                 .gitSubmodulesConfig(ProjectSourceGitSubmodulesConfigArgs.builder()
 *                     .fetchSubmodules(true)
 *                     .build())
 *                 .build())
 *             .sourceVersion("master")
 *             .vpcConfig(ProjectVpcConfigArgs.builder()
 *                 .vpcId(aws_vpc.example().id())
 *                 .subnets(
 *                     aws_subnet.example1().id(),
 *                     aws_subnet.example2().id())
 *                 .securityGroupIds(
 *                     aws_security_group.example1().id(),
 *                     aws_security_group.example2().id())
 *                 .build())
 *             .tags(Map.of("Environment", "Test"))
 *             .build());
 *         var project_with_cache = new Project("project-with-cache", ProjectArgs.builder()
 *             .description("test_codebuild_project_cache")
 *             .buildTimeout(5)
 *             .queuedTimeout(5)
 *             .serviceRole(exampleRole.arn())
 *             .artifacts(ProjectArtifactsArgs.builder()
 *                 .type("NO_ARTIFACTS")
 *                 .build())
 *             .cache(ProjectCacheArgs.builder()
 *                 .type("LOCAL")
 *                 .modes(
 *                     "LOCAL_DOCKER_LAYER_CACHE",
 *                     "LOCAL_SOURCE_CACHE")
 *                 .build())
 *             .environment(ProjectEnvironmentArgs.builder()
 *                 .computeType("BUILD_GENERAL1_SMALL")
 *                 .image("aws/codebuild/amazonlinux2-x86_64-standard:4.0")
 *                 .type("LINUX_CONTAINER")
 *                 .imagePullCredentialsType("CODEBUILD")
 *                 .environmentVariables(ProjectEnvironmentEnvironmentVariableArgs.builder()
 *                     .name("SOME_KEY1")
 *                     .value("SOME_VALUE1")
 *                     .build())
 *                 .build())
 *             .source(ProjectSourceArgs.builder()
 *                 .type("GITHUB")
 *                 .location("https://github.com/mitchellh/packer.git")
 *                 .gitCloneDepth(1)
 *                 .build())
 *             .tags(Map.of("Environment", "Test"))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import CodeBuild Project using the `name`. For example:
 * ```sh
 *  $ pulumi import aws:codebuild/project:Project name project-name
 * ```
 * */*/
 */
public class Project internal constructor(
    override val javaResource: com.pulumi.aws.codebuild.Project,
) : KotlinCustomResource(javaResource, ProjectMapper) {
    /**
     * ARN of the CodeBuild project.
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * Configuration block. Detailed below.
     */
    public val artifacts: Output<ProjectArtifacts>
        get() = javaResource.artifacts().applyValue({ args0 ->
            args0.let({ args0 ->
                projectArtifactsToKotlin(args0)
            })
        })

    /**
     * Generates a publicly-accessible URL for the projects build badge. Available as `badge_url` attribute when enabled.
     */
    public val badgeEnabled: Output<Boolean>?
        get() = javaResource.badgeEnabled().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * URL of the build badge when `badge_enabled` is enabled.
     */
    public val badgeUrl: Output<String>
        get() = javaResource.badgeUrl().applyValue({ args0 -> args0 })

    /**
     * Defines the batch build options for the project.
     */
    public val buildBatchConfig: Output<ProjectBuildBatchConfig>?
        get() = javaResource.buildBatchConfig().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> projectBuildBatchConfigToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * Number of minutes, from 5 to 480 (8 hours), for AWS CodeBuild to wait until timing out any related build that does not get marked as completed. The default is 60 minutes.
     */
    public val buildTimeout: Output<Int>?
        get() = javaResource.buildTimeout().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Configuration block. Detailed below.
     */
    public val cache: Output<ProjectCache>?
        get() = javaResource.cache().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    projectCacheToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * Specify a maximum number of concurrent builds for the project. The value specified must be greater than 0 and less than the account concurrent running builds limit.
     */
    public val concurrentBuildLimit: Output<Int>?
        get() = javaResource.concurrentBuildLimit().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Short description of the project.
     */
    public val description: Output<String>
        get() = javaResource.description().applyValue({ args0 -> args0 })

    /**
     * AWS Key Management Service (AWS KMS) customer master key (CMK) to be used for encrypting the build project's build output artifacts.
     */
    public val encryptionKey: Output<String>
        get() = javaResource.encryptionKey().applyValue({ args0 -> args0 })

    /**
     * Configuration block. Detailed below.
     */
    public val environment: Output<ProjectEnvironment>
        get() = javaResource.environment().applyValue({ args0 ->
            args0.let({ args0 ->
                projectEnvironmentToKotlin(args0)
            })
        })

    /**
     * A set of file system locations to mount inside the build. File system locations are documented below.
     */
    public val fileSystemLocations: Output<List<ProjectFileSystemLocation>>?
        get() = javaResource.fileSystemLocations().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 ->
                        projectFileSystemLocationToKotlin(args0)
                    })
                })
            }).orElse(null)
        })

    /**
     * Configuration block. Detailed below.
     */
    public val logsConfig: Output<ProjectLogsConfig>?
        get() = javaResource.logsConfig().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    projectLogsConfigToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * Project's name.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Specifies the visibility of the project's builds. Possible values are: `PUBLIC_READ` and `PRIVATE`. Default value is `PRIVATE`.
     */
    public val projectVisibility: Output<String>?
        get() = javaResource.projectVisibility().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The project identifier used with the public build APIs.
     */
    public val publicProjectAlias: Output<String>
        get() = javaResource.publicProjectAlias().applyValue({ args0 -> args0 })

    /**
     * Number of minutes, from 5 to 480 (8 hours), a build is allowed to be queued before it times out. The default is 8 hours.
     */
    public val queuedTimeout: Output<Int>?
        get() = javaResource.queuedTimeout().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The ARN of the IAM role that enables CodeBuild to access the CloudWatch Logs and Amazon S3 artifacts for the project's builds.
     */
    public val resourceAccessRole: Output<String>?
        get() = javaResource.resourceAccessRole().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Configuration block. Detailed below.
     */
    public val secondaryArtifacts: Output<List<ProjectSecondaryArtifact>>?
        get() = javaResource.secondaryArtifacts().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 ->
                        projectSecondaryArtifactToKotlin(args0)
                    })
                })
            }).orElse(null)
        })

    /**
     * Configuration block. Detailed below.
     */
    public val secondarySourceVersions: Output<List<ProjectSecondarySourceVersion>>?
        get() = javaResource.secondarySourceVersions().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 ->
                        projectSecondarySourceVersionToKotlin(args0)
                    })
                })
            }).orElse(null)
        })

    /**
     * Configuration block. Detailed below.
     */
    public val secondarySources: Output<List<ProjectSecondarySource>>?
        get() = javaResource.secondarySources().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 ->
                        projectSecondarySourceToKotlin(args0)
                    })
                })
            }).orElse(null)
        })

    /**
     * Amazon Resource Name (ARN) of the AWS Identity and Access Management (IAM) role that enables AWS CodeBuild to interact with dependent AWS services on behalf of the AWS account.
     */
    public val serviceRole: Output<String>
        get() = javaResource.serviceRole().applyValue({ args0 -> args0 })

    /**
     * Configuration block. Detailed below.
     * The following arguments are optional:
     */
    public val source: Output<ProjectSource>
        get() = javaResource.source().applyValue({ args0 ->
            args0.let({ args0 ->
                projectSourceToKotlin(args0)
            })
        })

    /**
     * Version of the build input to be built for this project. If not specified, the latest version is used.
     */
    public val sourceVersion: Output<String>?
        get() = javaResource.sourceVersion().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     */
    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })

    /**
     * Configuration block. Detailed below.
     */
    public val vpcConfig: Output<ProjectVpcConfig>?
        get() = javaResource.vpcConfig().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    projectVpcConfigToKotlin(args0)
                })
            }).orElse(null)
        })
}

public object ProjectMapper : ResourceMapper<Project> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.codebuild.Project::class == javaResource::class

    override fun map(javaResource: Resource): Project = Project(
        javaResource as
            com.pulumi.aws.codebuild.Project,
    )
}

/**
 * @see [Project].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Project].
 */
public suspend fun project(name: String, block: suspend ProjectResourceBuilder.() -> Unit):
    Project {
    val builder = ProjectResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Project].
 * @param name The _unique_ name of the resulting resource.
 */
public fun project(name: String): Project {
    val builder = ProjectResourceBuilder()
    builder.name(name)
    return builder.build()
}
