@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.codebuild.kotlin

import com.pulumi.aws.codebuild.ProjectArgs.builder
import com.pulumi.aws.codebuild.kotlin.inputs.ProjectArtifactsArgs
import com.pulumi.aws.codebuild.kotlin.inputs.ProjectArtifactsArgsBuilder
import com.pulumi.aws.codebuild.kotlin.inputs.ProjectBuildBatchConfigArgs
import com.pulumi.aws.codebuild.kotlin.inputs.ProjectBuildBatchConfigArgsBuilder
import com.pulumi.aws.codebuild.kotlin.inputs.ProjectCacheArgs
import com.pulumi.aws.codebuild.kotlin.inputs.ProjectCacheArgsBuilder
import com.pulumi.aws.codebuild.kotlin.inputs.ProjectEnvironmentArgs
import com.pulumi.aws.codebuild.kotlin.inputs.ProjectEnvironmentArgsBuilder
import com.pulumi.aws.codebuild.kotlin.inputs.ProjectFileSystemLocationArgs
import com.pulumi.aws.codebuild.kotlin.inputs.ProjectFileSystemLocationArgsBuilder
import com.pulumi.aws.codebuild.kotlin.inputs.ProjectLogsConfigArgs
import com.pulumi.aws.codebuild.kotlin.inputs.ProjectLogsConfigArgsBuilder
import com.pulumi.aws.codebuild.kotlin.inputs.ProjectSecondaryArtifactArgs
import com.pulumi.aws.codebuild.kotlin.inputs.ProjectSecondaryArtifactArgsBuilder
import com.pulumi.aws.codebuild.kotlin.inputs.ProjectSecondarySourceArgs
import com.pulumi.aws.codebuild.kotlin.inputs.ProjectSecondarySourceArgsBuilder
import com.pulumi.aws.codebuild.kotlin.inputs.ProjectSecondarySourceVersionArgs
import com.pulumi.aws.codebuild.kotlin.inputs.ProjectSecondarySourceVersionArgsBuilder
import com.pulumi.aws.codebuild.kotlin.inputs.ProjectSourceArgs
import com.pulumi.aws.codebuild.kotlin.inputs.ProjectSourceArgsBuilder
import com.pulumi.aws.codebuild.kotlin.inputs.ProjectVpcConfigArgs
import com.pulumi.aws.codebuild.kotlin.inputs.ProjectVpcConfigArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Int
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Provides a CodeBuild Project resource. See also the `aws.codebuild.Webhook` resource, which manages the webhook to the source (e.g., the "rebuild every time a code change is pushed" option in the CodeBuild web console).
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.s3.BucketV2;
 * import com.pulumi.aws.s3.BucketAclV2;
 * import com.pulumi.aws.s3.BucketAclV2Args;
 * import com.pulumi.aws.iam.IamFunctions;
 * import com.pulumi.aws.iam.inputs.GetPolicyDocumentArgs;
 * import com.pulumi.aws.iam.Role;
 * import com.pulumi.aws.iam.RoleArgs;
 * import com.pulumi.aws.iam.RolePolicy;
 * import com.pulumi.aws.iam.RolePolicyArgs;
 * import com.pulumi.aws.codebuild.Project;
 * import com.pulumi.aws.codebuild.ProjectArgs;
 * import com.pulumi.aws.codebuild.inputs.ProjectArtifactsArgs;
 * import com.pulumi.aws.codebuild.inputs.ProjectCacheArgs;
 * import com.pulumi.aws.codebuild.inputs.ProjectEnvironmentArgs;
 * import com.pulumi.aws.codebuild.inputs.ProjectLogsConfigArgs;
 * import com.pulumi.aws.codebuild.inputs.ProjectLogsConfigCloudwatchLogsArgs;
 * import com.pulumi.aws.codebuild.inputs.ProjectLogsConfigS3LogsArgs;
 * import com.pulumi.aws.codebuild.inputs.ProjectSourceArgs;
 * import com.pulumi.aws.codebuild.inputs.ProjectSourceGitSubmodulesConfigArgs;
 * import com.pulumi.aws.codebuild.inputs.ProjectVpcConfigArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var exampleBucketV2 = new BucketV2("exampleBucketV2");
 *         var exampleBucketAclV2 = new BucketAclV2("exampleBucketAclV2", BucketAclV2Args.builder()
 *             .bucket(exampleBucketV2.id())
 *             .acl("private")
 *             .build());
 *         final var assumeRole = IamFunctions.getPolicyDocument(GetPolicyDocumentArgs.builder()
 *             .statements(GetPolicyDocumentStatementArgs.builder()
 *                 .effect("Allow")
 *                 .principals(GetPolicyDocumentStatementPrincipalArgs.builder()
 *                     .type("Service")
 *                     .identifiers("codebuild.amazonaws.com")
 *                     .build())
 *                 .actions("sts:AssumeRole")
 *                 .build())
 *             .build());
 *         var exampleRole = new Role("exampleRole", RoleArgs.builder()
 *             .assumeRolePolicy(assumeRole.applyValue(getPolicyDocumentResult -> getPolicyDocumentResult.json()))
 *             .build());
 *         final var examplePolicyDocument = IamFunctions.getPolicyDocument(GetPolicyDocumentArgs.builder()
 *             .statements(
 *                 GetPolicyDocumentStatementArgs.builder()
 *                     .effect("Allow")
 *                     .actions(
 *                         "logs:CreateLogGroup",
 *                         "logs:CreateLogStream",
 *                         "logs:PutLogEvents")
 *                     .resources("*")
 *                     .build(),
 *                 GetPolicyDocumentStatementArgs.builder()
 *                     .effect("Allow")
 *                     .actions(
 *                         "ec2:CreateNetworkInterface",
 *                         "ec2:DescribeDhcpOptions",
 *                         "ec2:DescribeNetworkInterfaces",
 *                         "ec2:DeleteNetworkInterface",
 *                         "ec2:DescribeSubnets",
 *                         "ec2:DescribeSecurityGroups",
 *                         "ec2:DescribeVpcs")
 *                     .resources("*")
 *                     .build(),
 *                 GetPolicyDocumentStatementArgs.builder()
 *                     .effect("Allow")
 *                     .actions("ec2:CreateNetworkInterfacePermission")
 *                     .resources("arn:aws:ec2:us-east-1:123456789012:network-interface/*")
 *                     .conditions(
 *                         GetPolicyDocumentStatementConditionArgs.builder()
 *                             .test("StringEquals")
 *                             .variable("ec2:Subnet")
 *                             .values(
 *                                 aws_subnet.example1().arn(),
 *                                 aws_subnet.example2().arn())
 *                             .build(),
 *                         GetPolicyDocumentStatementConditionArgs.builder()
 *                             .test("StringEquals")
 *                             .variable("ec2:AuthorizedService")
 *                             .values("codebuild.amazonaws.com")
 *                             .build())
 *                     .build(),
 *                 GetPolicyDocumentStatementArgs.builder()
 *                     .effect("Allow")
 *                     .actions("s3:*")
 *                     .resources(
 *                         exampleBucketV2.arn(),
 *                         exampleBucketV2.arn().applyValue(arn -> String.format("%s/*", arn)))
 *                     .build())
 *             .build());
 *         var exampleRolePolicy = new RolePolicy("exampleRolePolicy", RolePolicyArgs.builder()
 *             .role(exampleRole.name())
 *             .policy(examplePolicyDocument.applyValue(getPolicyDocumentResult -> getPolicyDocumentResult).applyValue(examplePolicyDocument -> examplePolicyDocument.applyValue(getPolicyDocumentResult -> getPolicyDocumentResult.json())))
 *             .build());
 *         var exampleProject = new Project("exampleProject", ProjectArgs.builder()
 *             .description("test_codebuild_project")
 *             .buildTimeout(5)
 *             .serviceRole(exampleRole.arn())
 *             .artifacts(ProjectArtifactsArgs.builder()
 *                 .type("NO_ARTIFACTS")
 *                 .build())
 *             .cache(ProjectCacheArgs.builder()
 *                 .type("S3")
 *                 .location(exampleBucketV2.bucket())
 *                 .build())
 *             .environment(ProjectEnvironmentArgs.builder()
 *                 .computeType("BUILD_GENERAL1_SMALL")
 *                 .image("aws/codebuild/amazonlinux2-x86_64-standard:4.0")
 *                 .type("LINUX_CONTAINER")
 *                 .imagePullCredentialsType("CODEBUILD")
 *                 .environmentVariables(
 *                     ProjectEnvironmentEnvironmentVariableArgs.builder()
 *                         .name("SOME_KEY1")
 *                         .value("SOME_VALUE1")
 *                         .build(),
 *                     ProjectEnvironmentEnvironmentVariableArgs.builder()
 *                         .name("SOME_KEY2")
 *                         .value("SOME_VALUE2")
 *                         .type("PARAMETER_STORE")
 *                         .build())
 *                 .build())
 *             .logsConfig(ProjectLogsConfigArgs.builder()
 *                 .cloudwatchLogs(ProjectLogsConfigCloudwatchLogsArgs.builder()
 *                     .groupName("log-group")
 *                     .streamName("log-stream")
 *                     .build())
 *                 .s3Logs(ProjectLogsConfigS3LogsArgs.builder()
 *                     .status("ENABLED")
 *                     .location(exampleBucketV2.id().applyValue(id -> String.format("%s/build-log", id)))
 *                     .build())
 *                 .build())
 *             .source(ProjectSourceArgs.builder()
 *                 .type("GITHUB")
 *                 .location("https://github.com/mitchellh/packer.git")
 *                 .gitCloneDepth(1)
 *                 .gitSubmodulesConfig(ProjectSourceGitSubmodulesConfigArgs.builder()
 *                     .fetchSubmodules(true)
 *                     .build())
 *                 .build())
 *             .sourceVersion("master")
 *             .vpcConfig(ProjectVpcConfigArgs.builder()
 *                 .vpcId(aws_vpc.example().id())
 *                 .subnets(
 *                     aws_subnet.example1().id(),
 *                     aws_subnet.example2().id())
 *                 .securityGroupIds(
 *                     aws_security_group.example1().id(),
 *                     aws_security_group.example2().id())
 *                 .build())
 *             .tags(Map.of("Environment", "Test"))
 *             .build());
 *         var project_with_cache = new Project("project-with-cache", ProjectArgs.builder()
 *             .description("test_codebuild_project_cache")
 *             .buildTimeout(5)
 *             .queuedTimeout(5)
 *             .serviceRole(exampleRole.arn())
 *             .artifacts(ProjectArtifactsArgs.builder()
 *                 .type("NO_ARTIFACTS")
 *                 .build())
 *             .cache(ProjectCacheArgs.builder()
 *                 .type("LOCAL")
 *                 .modes(
 *                     "LOCAL_DOCKER_LAYER_CACHE",
 *                     "LOCAL_SOURCE_CACHE")
 *                 .build())
 *             .environment(ProjectEnvironmentArgs.builder()
 *                 .computeType("BUILD_GENERAL1_SMALL")
 *                 .image("aws/codebuild/amazonlinux2-x86_64-standard:4.0")
 *                 .type("LINUX_CONTAINER")
 *                 .imagePullCredentialsType("CODEBUILD")
 *                 .environmentVariables(ProjectEnvironmentEnvironmentVariableArgs.builder()
 *                     .name("SOME_KEY1")
 *                     .value("SOME_VALUE1")
 *                     .build())
 *                 .build())
 *             .source(ProjectSourceArgs.builder()
 *                 .type("GITHUB")
 *                 .location("https://github.com/mitchellh/packer.git")
 *                 .gitCloneDepth(1)
 *                 .build())
 *             .tags(Map.of("Environment", "Test"))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import CodeBuild Project using the `name`. For example:
 * ```sh
 *  $ pulumi import aws:codebuild/project:Project name project-name
 * ```
 * @property artifacts Configuration block. Detailed below.
 * @property badgeEnabled Generates a publicly-accessible URL for the projects build badge. Available as `badge_url` attribute when enabled.
 * @property buildBatchConfig Defines the batch build options for the project.
 * @property buildTimeout Number of minutes, from 5 to 480 (8 hours), for AWS CodeBuild to wait until timing out any related build that does not get marked as completed. The default is 60 minutes.
 * @property cache Configuration block. Detailed below.
 * @property concurrentBuildLimit Specify a maximum number of concurrent builds for the project. The value specified must be greater than 0 and less than the account concurrent running builds limit.
 * @property description Short description of the project.
 * @property encryptionKey AWS Key Management Service (AWS KMS) customer master key (CMK) to be used for encrypting the build project's build output artifacts.
 * @property environment Configuration block. Detailed below.
 * @property fileSystemLocations A set of file system locations to mount inside the build. File system locations are documented below.
 * @property logsConfig Configuration block. Detailed below.
 * @property name Project's name.
 * @property projectVisibility Specifies the visibility of the project's builds. Possible values are: `PUBLIC_READ` and `PRIVATE`. Default value is `PRIVATE`.
 * @property queuedTimeout Number of minutes, from 5 to 480 (8 hours), a build is allowed to be queued before it times out. The default is 8 hours.
 * @property resourceAccessRole The ARN of the IAM role that enables CodeBuild to access the CloudWatch Logs and Amazon S3 artifacts for the project's builds.
 * @property secondaryArtifacts Configuration block. Detailed below.
 * @property secondarySourceVersions Configuration block. Detailed below.
 * @property secondarySources Configuration block. Detailed below.
 * @property serviceRole Amazon Resource Name (ARN) of the AWS Identity and Access Management (IAM) role that enables AWS CodeBuild to interact with dependent AWS services on behalf of the AWS account.
 * @property source Configuration block. Detailed below.
 * The following arguments are optional:
 * @property sourceVersion Version of the build input to be built for this project. If not specified, the latest version is used.
 * @property tags Map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 * @property vpcConfig Configuration block. Detailed below.
 * */*/
 */
public data class ProjectArgs(
    public val artifacts: Output<ProjectArtifactsArgs>? = null,
    public val badgeEnabled: Output<Boolean>? = null,
    public val buildBatchConfig: Output<ProjectBuildBatchConfigArgs>? = null,
    public val buildTimeout: Output<Int>? = null,
    public val cache: Output<ProjectCacheArgs>? = null,
    public val concurrentBuildLimit: Output<Int>? = null,
    public val description: Output<String>? = null,
    public val encryptionKey: Output<String>? = null,
    public val environment: Output<ProjectEnvironmentArgs>? = null,
    public val fileSystemLocations: Output<List<ProjectFileSystemLocationArgs>>? = null,
    public val logsConfig: Output<ProjectLogsConfigArgs>? = null,
    public val name: Output<String>? = null,
    public val projectVisibility: Output<String>? = null,
    public val queuedTimeout: Output<Int>? = null,
    public val resourceAccessRole: Output<String>? = null,
    public val secondaryArtifacts: Output<List<ProjectSecondaryArtifactArgs>>? = null,
    public val secondarySourceVersions: Output<List<ProjectSecondarySourceVersionArgs>>? = null,
    public val secondarySources: Output<List<ProjectSecondarySourceArgs>>? = null,
    public val serviceRole: Output<String>? = null,
    public val source: Output<ProjectSourceArgs>? = null,
    public val sourceVersion: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val vpcConfig: Output<ProjectVpcConfigArgs>? = null,
) : ConvertibleToJava<com.pulumi.aws.codebuild.ProjectArgs> {
    override fun toJava(): com.pulumi.aws.codebuild.ProjectArgs =
        com.pulumi.aws.codebuild.ProjectArgs.builder()
            .artifacts(artifacts?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .badgeEnabled(badgeEnabled?.applyValue({ args0 -> args0 }))
            .buildBatchConfig(buildBatchConfig?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .buildTimeout(buildTimeout?.applyValue({ args0 -> args0 }))
            .cache(cache?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .concurrentBuildLimit(concurrentBuildLimit?.applyValue({ args0 -> args0 }))
            .description(description?.applyValue({ args0 -> args0 }))
            .encryptionKey(encryptionKey?.applyValue({ args0 -> args0 }))
            .environment(environment?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .fileSystemLocations(
                fileSystemLocations?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .logsConfig(logsConfig?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .name(name?.applyValue({ args0 -> args0 }))
            .projectVisibility(projectVisibility?.applyValue({ args0 -> args0 }))
            .queuedTimeout(queuedTimeout?.applyValue({ args0 -> args0 }))
            .resourceAccessRole(resourceAccessRole?.applyValue({ args0 -> args0 }))
            .secondaryArtifacts(
                secondaryArtifacts?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .secondarySourceVersions(
                secondarySourceVersions?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .secondarySources(
                secondarySources?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .serviceRole(serviceRole?.applyValue({ args0 -> args0 }))
            .source(source?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .sourceVersion(sourceVersion?.applyValue({ args0 -> args0 }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .vpcConfig(vpcConfig?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [ProjectArgs].
 */
@PulumiTagMarker
public class ProjectArgsBuilder internal constructor() {
    private var artifacts: Output<ProjectArtifactsArgs>? = null

    private var badgeEnabled: Output<Boolean>? = null

    private var buildBatchConfig: Output<ProjectBuildBatchConfigArgs>? = null

    private var buildTimeout: Output<Int>? = null

    private var cache: Output<ProjectCacheArgs>? = null

    private var concurrentBuildLimit: Output<Int>? = null

    private var description: Output<String>? = null

    private var encryptionKey: Output<String>? = null

    private var environment: Output<ProjectEnvironmentArgs>? = null

    private var fileSystemLocations: Output<List<ProjectFileSystemLocationArgs>>? = null

    private var logsConfig: Output<ProjectLogsConfigArgs>? = null

    private var name: Output<String>? = null

    private var projectVisibility: Output<String>? = null

    private var queuedTimeout: Output<Int>? = null

    private var resourceAccessRole: Output<String>? = null

    private var secondaryArtifacts: Output<List<ProjectSecondaryArtifactArgs>>? = null

    private var secondarySourceVersions: Output<List<ProjectSecondarySourceVersionArgs>>? = null

    private var secondarySources: Output<List<ProjectSecondarySourceArgs>>? = null

    private var serviceRole: Output<String>? = null

    private var source: Output<ProjectSourceArgs>? = null

    private var sourceVersion: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    private var vpcConfig: Output<ProjectVpcConfigArgs>? = null

    /**
     * @param value Configuration block. Detailed below.
     */
    @JvmName("thpgiqkblhxhvaja")
    public suspend fun artifacts(`value`: Output<ProjectArtifactsArgs>) {
        this.artifacts = value
    }

    /**
     * @param value Generates a publicly-accessible URL for the projects build badge. Available as `badge_url` attribute when enabled.
     */
    @JvmName("buqitllyudcakega")
    public suspend fun badgeEnabled(`value`: Output<Boolean>) {
        this.badgeEnabled = value
    }

    /**
     * @param value Defines the batch build options for the project.
     */
    @JvmName("udxfannrehaxuxta")
    public suspend fun buildBatchConfig(`value`: Output<ProjectBuildBatchConfigArgs>) {
        this.buildBatchConfig = value
    }

    /**
     * @param value Number of minutes, from 5 to 480 (8 hours), for AWS CodeBuild to wait until timing out any related build that does not get marked as completed. The default is 60 minutes.
     */
    @JvmName("egtnnxuhonnnwxvc")
    public suspend fun buildTimeout(`value`: Output<Int>) {
        this.buildTimeout = value
    }

    /**
     * @param value Configuration block. Detailed below.
     */
    @JvmName("jbxohlpdntwknyld")
    public suspend fun cache(`value`: Output<ProjectCacheArgs>) {
        this.cache = value
    }

    /**
     * @param value Specify a maximum number of concurrent builds for the project. The value specified must be greater than 0 and less than the account concurrent running builds limit.
     */
    @JvmName("jkrhhcabxkpvhtga")
    public suspend fun concurrentBuildLimit(`value`: Output<Int>) {
        this.concurrentBuildLimit = value
    }

    /**
     * @param value Short description of the project.
     */
    @JvmName("rfclwylhrhamfgnl")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value AWS Key Management Service (AWS KMS) customer master key (CMK) to be used for encrypting the build project's build output artifacts.
     */
    @JvmName("tojdletmlwgfscwm")
    public suspend fun encryptionKey(`value`: Output<String>) {
        this.encryptionKey = value
    }

    /**
     * @param value Configuration block. Detailed below.
     */
    @JvmName("tpmlcaviwvnisxfe")
    public suspend fun environment(`value`: Output<ProjectEnvironmentArgs>) {
        this.environment = value
    }

    /**
     * @param value A set of file system locations to mount inside the build. File system locations are documented below.
     */
    @JvmName("lghkhlovfymullxk")
    public suspend fun fileSystemLocations(`value`: Output<List<ProjectFileSystemLocationArgs>>) {
        this.fileSystemLocations = value
    }

    @JvmName("qmqcldmedwnnhiwa")
    public suspend fun fileSystemLocations(vararg values: Output<ProjectFileSystemLocationArgs>) {
        this.fileSystemLocations = Output.all(values.asList())
    }

    /**
     * @param values A set of file system locations to mount inside the build. File system locations are documented below.
     */
    @JvmName("ebwnwwngkheisnbe")
    public suspend fun fileSystemLocations(values: List<Output<ProjectFileSystemLocationArgs>>) {
        this.fileSystemLocations = Output.all(values)
    }

    /**
     * @param value Configuration block. Detailed below.
     */
    @JvmName("suyntrrwpbrgshcs")
    public suspend fun logsConfig(`value`: Output<ProjectLogsConfigArgs>) {
        this.logsConfig = value
    }

    /**
     * @param value Project's name.
     */
    @JvmName("ltcwlgyphhoqabgh")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Specifies the visibility of the project's builds. Possible values are: `PUBLIC_READ` and `PRIVATE`. Default value is `PRIVATE`.
     */
    @JvmName("hotneqctyxohibjs")
    public suspend fun projectVisibility(`value`: Output<String>) {
        this.projectVisibility = value
    }

    /**
     * @param value Number of minutes, from 5 to 480 (8 hours), a build is allowed to be queued before it times out. The default is 8 hours.
     */
    @JvmName("lotutxolhqbmyvdv")
    public suspend fun queuedTimeout(`value`: Output<Int>) {
        this.queuedTimeout = value
    }

    /**
     * @param value The ARN of the IAM role that enables CodeBuild to access the CloudWatch Logs and Amazon S3 artifacts for the project's builds.
     */
    @JvmName("pooiusmxhstiuuby")
    public suspend fun resourceAccessRole(`value`: Output<String>) {
        this.resourceAccessRole = value
    }

    /**
     * @param value Configuration block. Detailed below.
     */
    @JvmName("mmcyabvqdynrsgsw")
    public suspend fun secondaryArtifacts(`value`: Output<List<ProjectSecondaryArtifactArgs>>) {
        this.secondaryArtifacts = value
    }

    @JvmName("jklcgefgvfejfurj")
    public suspend fun secondaryArtifacts(vararg values: Output<ProjectSecondaryArtifactArgs>) {
        this.secondaryArtifacts = Output.all(values.asList())
    }

    /**
     * @param values Configuration block. Detailed below.
     */
    @JvmName("vqlouhogpnhktpab")
    public suspend fun secondaryArtifacts(values: List<Output<ProjectSecondaryArtifactArgs>>) {
        this.secondaryArtifacts = Output.all(values)
    }

    /**
     * @param value Configuration block. Detailed below.
     */
    @JvmName("uwgbvmkssubobvmj")
    public suspend
    fun secondarySourceVersions(`value`: Output<List<ProjectSecondarySourceVersionArgs>>) {
        this.secondarySourceVersions = value
    }

    @JvmName("sllbgonfruqopdtf")
    public suspend fun secondarySourceVersions(
        vararg
        values: Output<ProjectSecondarySourceVersionArgs>,
    ) {
        this.secondarySourceVersions = Output.all(values.asList())
    }

    /**
     * @param values Configuration block. Detailed below.
     */
    @JvmName("hlrewupjfqjhejda")
    public suspend
    fun secondarySourceVersions(values: List<Output<ProjectSecondarySourceVersionArgs>>) {
        this.secondarySourceVersions = Output.all(values)
    }

    /**
     * @param value Configuration block. Detailed below.
     */
    @JvmName("oyclxgcwkdcarabj")
    public suspend fun secondarySources(`value`: Output<List<ProjectSecondarySourceArgs>>) {
        this.secondarySources = value
    }

    @JvmName("wvyvugriiwjfijyq")
    public suspend fun secondarySources(vararg values: Output<ProjectSecondarySourceArgs>) {
        this.secondarySources = Output.all(values.asList())
    }

    /**
     * @param values Configuration block. Detailed below.
     */
    @JvmName("gbudsivsbueeriig")
    public suspend fun secondarySources(values: List<Output<ProjectSecondarySourceArgs>>) {
        this.secondarySources = Output.all(values)
    }

    /**
     * @param value Amazon Resource Name (ARN) of the AWS Identity and Access Management (IAM) role that enables AWS CodeBuild to interact with dependent AWS services on behalf of the AWS account.
     */
    @JvmName("oyrlrdstnspfktsk")
    public suspend fun serviceRole(`value`: Output<String>) {
        this.serviceRole = value
    }

    /**
     * @param value Configuration block. Detailed below.
     * The following arguments are optional:
     */
    @JvmName("trrdftgyrphsvnyg")
    public suspend fun source(`value`: Output<ProjectSourceArgs>) {
        this.source = value
    }

    /**
     * @param value Version of the build input to be built for this project. If not specified, the latest version is used.
     */
    @JvmName("lieuwhnrnnwgnlrg")
    public suspend fun sourceVersion(`value`: Output<String>) {
        this.sourceVersion = value
    }

    /**
     * @param value Map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("vqmgvnhytpyjyqbv")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Configuration block. Detailed below.
     */
    @JvmName("fhpevakimchinuhj")
    public suspend fun vpcConfig(`value`: Output<ProjectVpcConfigArgs>) {
        this.vpcConfig = value
    }

    /**
     * @param value Configuration block. Detailed below.
     */
    @JvmName("ishefuasxhlacrxc")
    public suspend fun artifacts(`value`: ProjectArtifactsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.artifacts = mapped
    }

    /**
     * @param argument Configuration block. Detailed below.
     */
    @JvmName("bdotpjyjgixkygds")
    public suspend fun artifacts(argument: suspend ProjectArtifactsArgsBuilder.() -> Unit) {
        val toBeMapped = ProjectArtifactsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.artifacts = mapped
    }

    /**
     * @param value Generates a publicly-accessible URL for the projects build badge. Available as `badge_url` attribute when enabled.
     */
    @JvmName("ifwotcoxpejlcfws")
    public suspend fun badgeEnabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.badgeEnabled = mapped
    }

    /**
     * @param value Defines the batch build options for the project.
     */
    @JvmName("cpfeveevbmmkwpus")
    public suspend fun buildBatchConfig(`value`: ProjectBuildBatchConfigArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.buildBatchConfig = mapped
    }

    /**
     * @param argument Defines the batch build options for the project.
     */
    @JvmName("qwhjabxxirbuderp")
    public suspend
    fun buildBatchConfig(argument: suspend ProjectBuildBatchConfigArgsBuilder.() -> Unit) {
        val toBeMapped = ProjectBuildBatchConfigArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.buildBatchConfig = mapped
    }

    /**
     * @param value Number of minutes, from 5 to 480 (8 hours), for AWS CodeBuild to wait until timing out any related build that does not get marked as completed. The default is 60 minutes.
     */
    @JvmName("qfbbyxkkolgbhgep")
    public suspend fun buildTimeout(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.buildTimeout = mapped
    }

    /**
     * @param value Configuration block. Detailed below.
     */
    @JvmName("bkntmeerveubaopo")
    public suspend fun cache(`value`: ProjectCacheArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.cache = mapped
    }

    /**
     * @param argument Configuration block. Detailed below.
     */
    @JvmName("agfnrbhjhghgnyno")
    public suspend fun cache(argument: suspend ProjectCacheArgsBuilder.() -> Unit) {
        val toBeMapped = ProjectCacheArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.cache = mapped
    }

    /**
     * @param value Specify a maximum number of concurrent builds for the project. The value specified must be greater than 0 and less than the account concurrent running builds limit.
     */
    @JvmName("ifnluqsyuvolpaln")
    public suspend fun concurrentBuildLimit(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.concurrentBuildLimit = mapped
    }

    /**
     * @param value Short description of the project.
     */
    @JvmName("swibjelxpoqyllda")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value AWS Key Management Service (AWS KMS) customer master key (CMK) to be used for encrypting the build project's build output artifacts.
     */
    @JvmName("jivrtfnamffjrdkr")
    public suspend fun encryptionKey(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.encryptionKey = mapped
    }

    /**
     * @param value Configuration block. Detailed below.
     */
    @JvmName("btsxkbqyaaylnjup")
    public suspend fun environment(`value`: ProjectEnvironmentArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.environment = mapped
    }

    /**
     * @param argument Configuration block. Detailed below.
     */
    @JvmName("kpdcakhweudvwvmv")
    public suspend fun environment(argument: suspend ProjectEnvironmentArgsBuilder.() -> Unit) {
        val toBeMapped = ProjectEnvironmentArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.environment = mapped
    }

    /**
     * @param value A set of file system locations to mount inside the build. File system locations are documented below.
     */
    @JvmName("awdtuidksadohpol")
    public suspend fun fileSystemLocations(`value`: List<ProjectFileSystemLocationArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.fileSystemLocations = mapped
    }

    /**
     * @param argument A set of file system locations to mount inside the build. File system locations are documented below.
     */
    @JvmName("xmlqbpdqiidxockc")
    public suspend
    fun fileSystemLocations(argument: List<suspend ProjectFileSystemLocationArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ProjectFileSystemLocationArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.fileSystemLocations = mapped
    }

    /**
     * @param argument A set of file system locations to mount inside the build. File system locations are documented below.
     */
    @JvmName("segrvjtlknhlxxmq")
    public suspend fun fileSystemLocations(
        vararg
        argument: suspend ProjectFileSystemLocationArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            ProjectFileSystemLocationArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.fileSystemLocations = mapped
    }

    /**
     * @param argument A set of file system locations to mount inside the build. File system locations are documented below.
     */
    @JvmName("ybsrdlwgcytkgonh")
    public suspend
    fun fileSystemLocations(argument: suspend ProjectFileSystemLocationArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            ProjectFileSystemLocationArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.fileSystemLocations = mapped
    }

    /**
     * @param values A set of file system locations to mount inside the build. File system locations are documented below.
     */
    @JvmName("pugaytokypmvmypw")
    public suspend fun fileSystemLocations(vararg values: ProjectFileSystemLocationArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.fileSystemLocations = mapped
    }

    /**
     * @param value Configuration block. Detailed below.
     */
    @JvmName("xltncglelmneuvgl")
    public suspend fun logsConfig(`value`: ProjectLogsConfigArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.logsConfig = mapped
    }

    /**
     * @param argument Configuration block. Detailed below.
     */
    @JvmName("uafbquslvxgebutp")
    public suspend fun logsConfig(argument: suspend ProjectLogsConfigArgsBuilder.() -> Unit) {
        val toBeMapped = ProjectLogsConfigArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.logsConfig = mapped
    }

    /**
     * @param value Project's name.
     */
    @JvmName("buspihqyevhcwcti")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Specifies the visibility of the project's builds. Possible values are: `PUBLIC_READ` and `PRIVATE`. Default value is `PRIVATE`.
     */
    @JvmName("nhydxcqebivnybow")
    public suspend fun projectVisibility(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.projectVisibility = mapped
    }

    /**
     * @param value Number of minutes, from 5 to 480 (8 hours), a build is allowed to be queued before it times out. The default is 8 hours.
     */
    @JvmName("iskagmtvyukvpbdi")
    public suspend fun queuedTimeout(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.queuedTimeout = mapped
    }

    /**
     * @param value The ARN of the IAM role that enables CodeBuild to access the CloudWatch Logs and Amazon S3 artifacts for the project's builds.
     */
    @JvmName("ttrhsqgcxlypjmbp")
    public suspend fun resourceAccessRole(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceAccessRole = mapped
    }

    /**
     * @param value Configuration block. Detailed below.
     */
    @JvmName("jeojcjyrcuxfvqyq")
    public suspend fun secondaryArtifacts(`value`: List<ProjectSecondaryArtifactArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.secondaryArtifacts = mapped
    }

    /**
     * @param argument Configuration block. Detailed below.
     */
    @JvmName("ucpmnryfsyvkghvw")
    public suspend
    fun secondaryArtifacts(argument: List<suspend ProjectSecondaryArtifactArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ProjectSecondaryArtifactArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.secondaryArtifacts = mapped
    }

    /**
     * @param argument Configuration block. Detailed below.
     */
    @JvmName("tmacowtojarwbsgu")
    public suspend fun secondaryArtifacts(
        vararg
        argument: suspend ProjectSecondaryArtifactArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            ProjectSecondaryArtifactArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.secondaryArtifacts = mapped
    }

    /**
     * @param argument Configuration block. Detailed below.
     */
    @JvmName("kbwkmwvraitwgxhd")
    public suspend
    fun secondaryArtifacts(argument: suspend ProjectSecondaryArtifactArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            ProjectSecondaryArtifactArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.secondaryArtifacts = mapped
    }

    /**
     * @param values Configuration block. Detailed below.
     */
    @JvmName("qlkubhdubwxntpjn")
    public suspend fun secondaryArtifacts(vararg values: ProjectSecondaryArtifactArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.secondaryArtifacts = mapped
    }

    /**
     * @param value Configuration block. Detailed below.
     */
    @JvmName("vwtqljaguythbfxl")
    public suspend fun secondarySourceVersions(`value`: List<ProjectSecondarySourceVersionArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.secondarySourceVersions = mapped
    }

    /**
     * @param argument Configuration block. Detailed below.
     */
    @JvmName("cgpvhcgldumcqywm")
    public suspend
    fun secondarySourceVersions(argument: List<suspend ProjectSecondarySourceVersionArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ProjectSecondarySourceVersionArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.secondarySourceVersions = mapped
    }

    /**
     * @param argument Configuration block. Detailed below.
     */
    @JvmName("hfdhdfhuarkusldi")
    public suspend fun secondarySourceVersions(
        vararg
        argument: suspend ProjectSecondarySourceVersionArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            ProjectSecondarySourceVersionArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.secondarySourceVersions = mapped
    }

    /**
     * @param argument Configuration block. Detailed below.
     */
    @JvmName("uucpxikakprfujdu")
    public suspend
    fun secondarySourceVersions(argument: suspend ProjectSecondarySourceVersionArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            ProjectSecondarySourceVersionArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.secondarySourceVersions = mapped
    }

    /**
     * @param values Configuration block. Detailed below.
     */
    @JvmName("qsvscthixgoeqbby")
    public suspend fun secondarySourceVersions(vararg values: ProjectSecondarySourceVersionArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.secondarySourceVersions = mapped
    }

    /**
     * @param value Configuration block. Detailed below.
     */
    @JvmName("fxcmfmqdbdotlith")
    public suspend fun secondarySources(`value`: List<ProjectSecondarySourceArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.secondarySources = mapped
    }

    /**
     * @param argument Configuration block. Detailed below.
     */
    @JvmName("rjfmkxcdeasnylhk")
    public suspend
    fun secondarySources(argument: List<suspend ProjectSecondarySourceArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ProjectSecondarySourceArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.secondarySources = mapped
    }

    /**
     * @param argument Configuration block. Detailed below.
     */
    @JvmName("saclmqboscjlrmdb")
    public suspend fun secondarySources(
        vararg
        argument: suspend ProjectSecondarySourceArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            ProjectSecondarySourceArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.secondarySources = mapped
    }

    /**
     * @param argument Configuration block. Detailed below.
     */
    @JvmName("oofpjsioubqmvljy")
    public suspend
    fun secondarySources(argument: suspend ProjectSecondarySourceArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(ProjectSecondarySourceArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.secondarySources = mapped
    }

    /**
     * @param values Configuration block. Detailed below.
     */
    @JvmName("vyxodbbxpgmrwrjc")
    public suspend fun secondarySources(vararg values: ProjectSecondarySourceArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.secondarySources = mapped
    }

    /**
     * @param value Amazon Resource Name (ARN) of the AWS Identity and Access Management (IAM) role that enables AWS CodeBuild to interact with dependent AWS services on behalf of the AWS account.
     */
    @JvmName("kfjbddsbiuuefntq")
    public suspend fun serviceRole(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.serviceRole = mapped
    }

    /**
     * @param value Configuration block. Detailed below.
     * The following arguments are optional:
     */
    @JvmName("kmwrliccdeggrdqs")
    public suspend fun source(`value`: ProjectSourceArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.source = mapped
    }

    /**
     * @param argument Configuration block. Detailed below.
     * The following arguments are optional:
     */
    @JvmName("tpfqlrdbrdkmtghn")
    public suspend fun source(argument: suspend ProjectSourceArgsBuilder.() -> Unit) {
        val toBeMapped = ProjectSourceArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.source = mapped
    }

    /**
     * @param value Version of the build input to be built for this project. If not specified, the latest version is used.
     */
    @JvmName("xjypotgytsijqxyw")
    public suspend fun sourceVersion(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sourceVersion = mapped
    }

    /**
     * @param value Map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("djerlaxacculdqgs")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("fxilrdkjbvbkcmrs")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value Configuration block. Detailed below.
     */
    @JvmName("arycwkuqgpyvkahg")
    public suspend fun vpcConfig(`value`: ProjectVpcConfigArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vpcConfig = mapped
    }

    /**
     * @param argument Configuration block. Detailed below.
     */
    @JvmName("lqeykdnrpqkcctaw")
    public suspend fun vpcConfig(argument: suspend ProjectVpcConfigArgsBuilder.() -> Unit) {
        val toBeMapped = ProjectVpcConfigArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.vpcConfig = mapped
    }

    internal fun build(): ProjectArgs = ProjectArgs(
        artifacts = artifacts,
        badgeEnabled = badgeEnabled,
        buildBatchConfig = buildBatchConfig,
        buildTimeout = buildTimeout,
        cache = cache,
        concurrentBuildLimit = concurrentBuildLimit,
        description = description,
        encryptionKey = encryptionKey,
        environment = environment,
        fileSystemLocations = fileSystemLocations,
        logsConfig = logsConfig,
        name = name,
        projectVisibility = projectVisibility,
        queuedTimeout = queuedTimeout,
        resourceAccessRole = resourceAccessRole,
        secondaryArtifacts = secondaryArtifacts,
        secondarySourceVersions = secondarySourceVersions,
        secondarySources = secondarySources,
        serviceRole = serviceRole,
        source = source,
        sourceVersion = sourceVersion,
        tags = tags,
        vpcConfig = vpcConfig,
    )
}
