@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.codebuild.kotlin

import com.pulumi.aws.codebuild.kotlin.outputs.ReportGroupExportConfig
import com.pulumi.aws.codebuild.kotlin.outputs.ReportGroupExportConfig.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map

/**
 * Builder for [ReportGroup].
 */
@PulumiTagMarker
public class ReportGroupResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ReportGroupArgs = ReportGroupArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ReportGroupArgsBuilder.() -> Unit) {
        val builder = ReportGroupArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): ReportGroup {
        val builtJavaResource = com.pulumi.aws.codebuild.ReportGroup(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return ReportGroup(builtJavaResource)
    }
}

/**
 * Provides a CodeBuild Report Groups Resource.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.AwsFunctions;
 * import com.pulumi.aws.inputs.GetCallerIdentityArgs;
 * import com.pulumi.aws.iam.IamFunctions;
 * import com.pulumi.aws.iam.inputs.GetPolicyDocumentArgs;
 * import com.pulumi.aws.kms.Key;
 * import com.pulumi.aws.kms.KeyArgs;
 * import com.pulumi.aws.s3.BucketV2;
 * import com.pulumi.aws.codebuild.ReportGroup;
 * import com.pulumi.aws.codebuild.ReportGroupArgs;
 * import com.pulumi.aws.codebuild.inputs.ReportGroupExportConfigArgs;
 * import com.pulumi.aws.codebuild.inputs.ReportGroupExportConfigS3DestinationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var current = AwsFunctions.getCallerIdentity();
 *         final var examplePolicyDocument = IamFunctions.getPolicyDocument(GetPolicyDocumentArgs.builder()
 *             .statements(GetPolicyDocumentStatementArgs.builder()
 *                 .sid("Enable IAM User Permissions")
 *                 .effect("Allow")
 *                 .principals(GetPolicyDocumentStatementPrincipalArgs.builder()
 *                     .type("AWS")
 *                     .identifiers(String.format("arn:aws:iam::%s:root", current.applyValue(getCallerIdentityResult -> getCallerIdentityResult.accountId())))
 *                     .build())
 *                 .actions("kms:*")
 *                 .resources("*")
 *                 .build())
 *             .build());
 *         var exampleKey = new Key("exampleKey", KeyArgs.builder()
 *             .description("my test kms key")
 *             .deletionWindowInDays(7)
 *             .policy(examplePolicyDocument.applyValue(getPolicyDocumentResult -> getPolicyDocumentResult.json()))
 *             .build());
 *         var exampleBucketV2 = new BucketV2("exampleBucketV2");
 *         var exampleReportGroup = new ReportGroup("exampleReportGroup", ReportGroupArgs.builder()
 *             .type("TEST")
 *             .exportConfig(ReportGroupExportConfigArgs.builder()
 *                 .type("S3")
 *                 .s3Destination(ReportGroupExportConfigS3DestinationArgs.builder()
 *                     .bucket(exampleBucketV2.id())
 *                     .encryptionDisabled(false)
 *                     .encryptionKey(exampleKey.arn())
 *                     .packaging("NONE")
 *                     .path("/some")
 *                     .build())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import CodeBuild Report Group using the CodeBuild Report Group arn. For example:
 * ```sh
 *  $ pulumi import aws:codebuild/reportGroup:ReportGroup example arn:aws:codebuild:us-west-2:123456789:report-group/report-group-name
 * ```
 *
 */
public class ReportGroup internal constructor(
    override val javaResource: com.pulumi.aws.codebuild.ReportGroup,
) : KotlinCustomResource(javaResource, ReportGroupMapper) {
    /**
     * The ARN of Report Group.
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * The date and time this Report Group was created.
     */
    public val created: Output<String>
        get() = javaResource.created().applyValue({ args0 -> args0 })

    /**
     * If `true`, deletes any reports that belong to a report group before deleting the report group. If `false`, you must delete any reports in the report group before deleting it. Default value is `false`.
     */
    public val deleteReports: Output<Boolean>?
        get() = javaResource.deleteReports().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Information about the destination where the raw data of this Report Group is exported. see Export Config documented below.
     */
    public val exportConfig: Output<ReportGroupExportConfig>
        get() = javaResource.exportConfig().applyValue({ args0 -> args0.let({ args0 -> toKotlin(args0) }) })

    /**
     * The name of a Report Group.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Key-value mapping of resource tags. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     */
    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })

    /**
     * The type of the Report Group. Valid value are `TEST` and `CODE_COVERAGE`.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object ReportGroupMapper : ResourceMapper<ReportGroup> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.codebuild.ReportGroup::class == javaResource::class

    override fun map(javaResource: Resource): ReportGroup = ReportGroup(
        javaResource as
            com.pulumi.aws.codebuild.ReportGroup,
    )
}

/**
 * @see [ReportGroup].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [ReportGroup].
 */
public suspend fun reportGroup(name: String, block: suspend ReportGroupResourceBuilder.() -> Unit):
    ReportGroup {
    val builder = ReportGroupResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [ReportGroup].
 * @param name The _unique_ name of the resulting resource.
 */
public fun reportGroup(name: String): ReportGroup {
    val builder = ReportGroupResourceBuilder()
    builder.name(name)
    return builder.build()
}
