@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.codebuild.kotlin

import com.pulumi.aws.codebuild.ReportGroupArgs.builder
import com.pulumi.aws.codebuild.kotlin.inputs.ReportGroupExportConfigArgs
import com.pulumi.aws.codebuild.kotlin.inputs.ReportGroupExportConfigArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Provides a CodeBuild Report Groups Resource.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.AwsFunctions;
 * import com.pulumi.aws.inputs.GetCallerIdentityArgs;
 * import com.pulumi.aws.iam.IamFunctions;
 * import com.pulumi.aws.iam.inputs.GetPolicyDocumentArgs;
 * import com.pulumi.aws.kms.Key;
 * import com.pulumi.aws.kms.KeyArgs;
 * import com.pulumi.aws.s3.BucketV2;
 * import com.pulumi.aws.codebuild.ReportGroup;
 * import com.pulumi.aws.codebuild.ReportGroupArgs;
 * import com.pulumi.aws.codebuild.inputs.ReportGroupExportConfigArgs;
 * import com.pulumi.aws.codebuild.inputs.ReportGroupExportConfigS3DestinationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var current = AwsFunctions.getCallerIdentity();
 *         final var examplePolicyDocument = IamFunctions.getPolicyDocument(GetPolicyDocumentArgs.builder()
 *             .statements(GetPolicyDocumentStatementArgs.builder()
 *                 .sid("Enable IAM User Permissions")
 *                 .effect("Allow")
 *                 .principals(GetPolicyDocumentStatementPrincipalArgs.builder()
 *                     .type("AWS")
 *                     .identifiers(String.format("arn:aws:iam::%s:root", current.applyValue(getCallerIdentityResult -> getCallerIdentityResult.accountId())))
 *                     .build())
 *                 .actions("kms:*")
 *                 .resources("*")
 *                 .build())
 *             .build());
 *         var exampleKey = new Key("exampleKey", KeyArgs.builder()
 *             .description("my test kms key")
 *             .deletionWindowInDays(7)
 *             .policy(examplePolicyDocument.applyValue(getPolicyDocumentResult -> getPolicyDocumentResult.json()))
 *             .build());
 *         var exampleBucketV2 = new BucketV2("exampleBucketV2");
 *         var exampleReportGroup = new ReportGroup("exampleReportGroup", ReportGroupArgs.builder()
 *             .type("TEST")
 *             .exportConfig(ReportGroupExportConfigArgs.builder()
 *                 .type("S3")
 *                 .s3Destination(ReportGroupExportConfigS3DestinationArgs.builder()
 *                     .bucket(exampleBucketV2.id())
 *                     .encryptionDisabled(false)
 *                     .encryptionKey(exampleKey.arn())
 *                     .packaging("NONE")
 *                     .path("/some")
 *                     .build())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import CodeBuild Report Group using the CodeBuild Report Group arn. For example:
 * ```sh
 *  $ pulumi import aws:codebuild/reportGroup:ReportGroup example arn:aws:codebuild:us-west-2:123456789:report-group/report-group-name
 * ```
 * @property deleteReports If `true`, deletes any reports that belong to a report group before deleting the report group. If `false`, you must delete any reports in the report group before deleting it. Default value is `false`.
 * @property exportConfig Information about the destination where the raw data of this Report Group is exported. see Export Config documented below.
 * @property name The name of a Report Group.
 * @property tags Key-value mapping of resource tags. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 * @property type The type of the Report Group. Valid value are `TEST` and `CODE_COVERAGE`.
 */
public data class ReportGroupArgs(
    public val deleteReports: Output<Boolean>? = null,
    public val exportConfig: Output<ReportGroupExportConfigArgs>? = null,
    public val name: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val type: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.codebuild.ReportGroupArgs> {
    override fun toJava(): com.pulumi.aws.codebuild.ReportGroupArgs =
        com.pulumi.aws.codebuild.ReportGroupArgs.builder()
            .deleteReports(deleteReports?.applyValue({ args0 -> args0 }))
            .exportConfig(exportConfig?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .name(name?.applyValue({ args0 -> args0 }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .type(type?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ReportGroupArgs].
 */
@PulumiTagMarker
public class ReportGroupArgsBuilder internal constructor() {
    private var deleteReports: Output<Boolean>? = null

    private var exportConfig: Output<ReportGroupExportConfigArgs>? = null

    private var name: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    private var type: Output<String>? = null

    /**
     * @param value If `true`, deletes any reports that belong to a report group before deleting the report group. If `false`, you must delete any reports in the report group before deleting it. Default value is `false`.
     */
    @JvmName("xwuhuyjkgyxpaqlp")
    public suspend fun deleteReports(`value`: Output<Boolean>) {
        this.deleteReports = value
    }

    /**
     * @param value Information about the destination where the raw data of this Report Group is exported. see Export Config documented below.
     */
    @JvmName("bxqbltrsfltshryj")
    public suspend fun exportConfig(`value`: Output<ReportGroupExportConfigArgs>) {
        this.exportConfig = value
    }

    /**
     * @param value The name of a Report Group.
     */
    @JvmName("awxtrveelofcciby")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Key-value mapping of resource tags. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("qbjwbhkhiwecvlms")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The type of the Report Group. Valid value are `TEST` and `CODE_COVERAGE`.
     */
    @JvmName("xxeoybieqhfycafg")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value If `true`, deletes any reports that belong to a report group before deleting the report group. If `false`, you must delete any reports in the report group before deleting it. Default value is `false`.
     */
    @JvmName("yxbfmealsmcsigww")
    public suspend fun deleteReports(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.deleteReports = mapped
    }

    /**
     * @param value Information about the destination where the raw data of this Report Group is exported. see Export Config documented below.
     */
    @JvmName("kkeucdvoajxgiktr")
    public suspend fun exportConfig(`value`: ReportGroupExportConfigArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.exportConfig = mapped
    }

    /**
     * @param argument Information about the destination where the raw data of this Report Group is exported. see Export Config documented below.
     */
    @JvmName("psltebdeqkxlhogt")
    public suspend fun exportConfig(argument: suspend ReportGroupExportConfigArgsBuilder.() -> Unit) {
        val toBeMapped = ReportGroupExportConfigArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.exportConfig = mapped
    }

    /**
     * @param value The name of a Report Group.
     */
    @JvmName("qyjxbmcffoohyjbo")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Key-value mapping of resource tags. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("dwklyatcerjmnltg")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Key-value mapping of resource tags. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("cccpisacfhgwpkdb")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value The type of the Report Group. Valid value are `TEST` and `CODE_COVERAGE`.
     */
    @JvmName("pbuldjonkqjnuiph")
    public suspend fun type(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.type = mapped
    }

    internal fun build(): ReportGroupArgs = ReportGroupArgs(
        deleteReports = deleteReports,
        exportConfig = exportConfig,
        name = name,
        tags = tags,
        type = type,
    )
}
