@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.codebuild.kotlin

import com.pulumi.aws.codebuild.ResourcePolicyArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Provides a CodeBuild Resource Policy Resource.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.codebuild.ReportGroup;
 * import com.pulumi.aws.codebuild.ReportGroupArgs;
 * import com.pulumi.aws.codebuild.inputs.ReportGroupExportConfigArgs;
 * import com.pulumi.aws.AwsFunctions;
 * import com.pulumi.aws.inputs.GetPartitionArgs;
 * import com.pulumi.aws.inputs.GetCallerIdentityArgs;
 * import com.pulumi.aws.codebuild.ResourcePolicy;
 * import com.pulumi.aws.codebuild.ResourcePolicyArgs;
 * import static com.pulumi.codegen.internal.Serialization.*;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var exampleReportGroup = new ReportGroup("exampleReportGroup", ReportGroupArgs.builder()
 *             .type("TEST")
 *             .exportConfig(ReportGroupExportConfigArgs.builder()
 *                 .type("NO_EXPORT")
 *                 .build())
 *             .build());
 *         final var currentPartition = AwsFunctions.getPartition();
 *         final var currentCallerIdentity = AwsFunctions.getCallerIdentity();
 *         var exampleResourcePolicy = new ResourcePolicy("exampleResourcePolicy", ResourcePolicyArgs.builder()
 *             .resourceArn(exampleReportGroup.arn())
 *             .policy(exampleReportGroup.arn().applyValue(arn -> serializeJson(
 *                 jsonObject(
 *                     jsonProperty("Version", "2012-10-17"),
 *                     jsonProperty("Id", "default"),
 *                     jsonProperty("Statement", jsonArray(jsonObject(
 *                         jsonProperty("Sid", "default"),
 *                         jsonProperty("Effect", "Allow"),
 *                         jsonProperty("Principal", jsonObject(
 *                             jsonProperty("AWS", String.format("arn:%s:iam::%s:root", currentPartition.applyValue(getPartitionResult -> getPartitionResult.partition()),currentCallerIdentity.applyValue(getCallerIdentityResult -> getCallerIdentityResult.accountId())))
 *                         )),
 *                         jsonProperty("Action", jsonArray(
 *                             "codebuild:BatchGetReportGroups",
 *                             "codebuild:BatchGetReports",
 *                             "codebuild:ListReportsForReportGroup",
 *                             "codebuild:DescribeTestCases"
 *                         )),
 *                         jsonProperty("Resource", arn)
 *                     )))
 *                 ))))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import CodeBuild Resource Policy using the CodeBuild Resource Policy arn. For example:
 * ```sh
 *  $ pulumi import aws:codebuild/resourcePolicy:ResourcePolicy example arn:aws:codebuild:us-west-2:123456789:report-group/report-group-name
 * ```
 * @property policy A JSON-formatted resource policy. For more information, see [Sharing a Projec](https://docs&#46;aws&#46;amazon&#46;com/codebuild/latest/userguide/project-sharing&#46;html#project-sharing-share) and [Sharing a Report Group](https://docs.aws.amazon.com/codebuild/latest/userguide/report-groups-sharing.html#report-groups-sharing-share).
 * @property resourceArn The ARN of the Project or ReportGroup resource you want to associate with a resource policy.
 */
public data class ResourcePolicyArgs(
    public val policy: Output<String>? = null,
    public val resourceArn: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.codebuild.ResourcePolicyArgs> {
    override fun toJava(): com.pulumi.aws.codebuild.ResourcePolicyArgs =
        com.pulumi.aws.codebuild.ResourcePolicyArgs.builder()
            .policy(policy?.applyValue({ args0 -> args0 }))
            .resourceArn(resourceArn?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ResourcePolicyArgs].
 */
@PulumiTagMarker
public class ResourcePolicyArgsBuilder internal constructor() {
    private var policy: Output<String>? = null

    private var resourceArn: Output<String>? = null

    /**
     * @param value A JSON-formatted resource policy. For more information, see [Sharing a Projec](https://docs&#46;aws&#46;amazon&#46;com/codebuild/latest/userguide/project-sharing&#46;html#project-sharing-share) and [Sharing a Report Group](https://docs.aws.amazon.com/codebuild/latest/userguide/report-groups-sharing.html#report-groups-sharing-share).
     */
    @JvmName("jesscpplxnqiwqri")
    public suspend fun policy(`value`: Output<String>) {
        this.policy = value
    }

    /**
     * @param value The ARN of the Project or ReportGroup resource you want to associate with a resource policy.
     */
    @JvmName("yfameovfelqpvpgv")
    public suspend fun resourceArn(`value`: Output<String>) {
        this.resourceArn = value
    }

    /**
     * @param value A JSON-formatted resource policy. For more information, see [Sharing a Projec](https://docs&#46;aws&#46;amazon&#46;com/codebuild/latest/userguide/project-sharing&#46;html#project-sharing-share) and [Sharing a Report Group](https://docs.aws.amazon.com/codebuild/latest/userguide/report-groups-sharing.html#report-groups-sharing-share).
     */
    @JvmName("lyxlvfdykkaanxtk")
    public suspend fun policy(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.policy = mapped
    }

    /**
     * @param value The ARN of the Project or ReportGroup resource you want to associate with a resource policy.
     */
    @JvmName("mwfsnrwquoxpakbr")
    public suspend fun resourceArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceArn = mapped
    }

    internal fun build(): ResourcePolicyArgs = ResourcePolicyArgs(
        policy = policy,
        resourceArn = resourceArn,
    )
}
