@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.codebuild.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [SourceCredential].
 */
@PulumiTagMarker
public class SourceCredentialResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: SourceCredentialArgs = SourceCredentialArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend SourceCredentialArgsBuilder.() -> Unit) {
        val builder = SourceCredentialArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): SourceCredential {
        val builtJavaResource = com.pulumi.aws.codebuild.SourceCredential(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return SourceCredential(builtJavaResource)
    }
}

/**
 * Provides a CodeBuild Source Credentials Resource.
 * > **NOTE:**
 * [Codebuild only allows a single credential per given server type in a given region](https://docs.aws.amazon.com/cdk/api/v2/docs/aws-cdk-lib.aws_codebuild.GitHubSourceCredentials.html). Therefore, when you define `aws.codebuild.SourceCredential`, `aws.codebuild.Project` resource defined in the same module will use it.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.codebuild.SourceCredential;
 * import com.pulumi.aws.codebuild.SourceCredentialArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new SourceCredential("example", SourceCredentialArgs.builder()
 *             .authType("PERSONAL_ACCESS_TOKEN")
 *             .serverType("GITHUB")
 *             .token("example")
 *             .build());
 *     }
 * }
 * ```
 * ### Bitbucket Server Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.codebuild.SourceCredential;
 * import com.pulumi.aws.codebuild.SourceCredentialArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new SourceCredential("example", SourceCredentialArgs.builder()
 *             .authType("BASIC_AUTH")
 *             .serverType("BITBUCKET")
 *             .token("example")
 *             .userName("test-user")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import CodeBuild Source Credential using the CodeBuild Source Credential arn. For example:
 * ```sh
 *  $ pulumi import aws:codebuild/sourceCredential:SourceCredential example arn:aws:codebuild:us-west-2:123456789:token:github
 * ```
 *
 */
public class SourceCredential internal constructor(
    override val javaResource: com.pulumi.aws.codebuild.SourceCredential,
) : KotlinCustomResource(javaResource, SourceCredentialMapper) {
    /**
     * The ARN of Source Credential.
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * The type of authentication used to connect to a GitHub, GitHub Enterprise, or Bitbucket repository. An OAUTH connection is not supported by the API.
     */
    public val authType: Output<String>
        get() = javaResource.authType().applyValue({ args0 -> args0 })

    /**
     * The source provider used for this project.
     */
    public val serverType: Output<String>
        get() = javaResource.serverType().applyValue({ args0 -> args0 })

    /**
     * For `GitHub` or `GitHub Enterprise`, this is the personal access token. For `Bitbucket`, this is the app password.
     */
    public val token: Output<String>
        get() = javaResource.token().applyValue({ args0 -> args0 })

    /**
     * The Bitbucket username when the authType is `BASIC_AUTH`. This parameter is not valid for other types of source providers or connections.
     */
    public val userName: Output<String>?
        get() = javaResource.userName().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })
}

public object SourceCredentialMapper : ResourceMapper<SourceCredential> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.codebuild.SourceCredential::class == javaResource::class

    override fun map(javaResource: Resource): SourceCredential = SourceCredential(
        javaResource as
            com.pulumi.aws.codebuild.SourceCredential,
    )
}

/**
 * @see [SourceCredential].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [SourceCredential].
 */
public suspend fun sourceCredential(
    name: String,
    block: suspend SourceCredentialResourceBuilder.() -> Unit,
): SourceCredential {
    val builder = SourceCredentialResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [SourceCredential].
 * @param name The _unique_ name of the resulting resource.
 */
public fun sourceCredential(name: String): SourceCredential {
    val builder = SourceCredentialResourceBuilder()
    builder.name(name)
    return builder.build()
}
