@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.codebuild.kotlin

import com.pulumi.aws.codebuild.SourceCredentialArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Provides a CodeBuild Source Credentials Resource.
 * > **NOTE:**
 * [Codebuild only allows a single credential per given server type in a given region](https://docs.aws.amazon.com/cdk/api/v2/docs/aws-cdk-lib.aws_codebuild.GitHubSourceCredentials.html). Therefore, when you define `aws.codebuild.SourceCredential`, `aws.codebuild.Project` resource defined in the same module will use it.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.codebuild.SourceCredential;
 * import com.pulumi.aws.codebuild.SourceCredentialArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new SourceCredential("example", SourceCredentialArgs.builder()
 *             .authType("PERSONAL_ACCESS_TOKEN")
 *             .serverType("GITHUB")
 *             .token("example")
 *             .build());
 *     }
 * }
 * ```
 * ### Bitbucket Server Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.codebuild.SourceCredential;
 * import com.pulumi.aws.codebuild.SourceCredentialArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new SourceCredential("example", SourceCredentialArgs.builder()
 *             .authType("BASIC_AUTH")
 *             .serverType("BITBUCKET")
 *             .token("example")
 *             .userName("test-user")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import CodeBuild Source Credential using the CodeBuild Source Credential arn. For example:
 * ```sh
 *  $ pulumi import aws:codebuild/sourceCredential:SourceCredential example arn:aws:codebuild:us-west-2:123456789:token:github
 * ```
 * @property authType The type of authentication used to connect to a GitHub, GitHub Enterprise, or Bitbucket repository. An OAUTH connection is not supported by the API.
 * @property serverType The source provider used for this project.
 * @property token For `GitHub` or `GitHub Enterprise`, this is the personal access token. For `Bitbucket`, this is the app password.
 * @property userName The Bitbucket username when the authType is `BASIC_AUTH`. This parameter is not valid for other types of source providers or connections.
 */
public data class SourceCredentialArgs(
    public val authType: Output<String>? = null,
    public val serverType: Output<String>? = null,
    public val token: Output<String>? = null,
    public val userName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.codebuild.SourceCredentialArgs> {
    override fun toJava(): com.pulumi.aws.codebuild.SourceCredentialArgs =
        com.pulumi.aws.codebuild.SourceCredentialArgs.builder()
            .authType(authType?.applyValue({ args0 -> args0 }))
            .serverType(serverType?.applyValue({ args0 -> args0 }))
            .token(token?.applyValue({ args0 -> args0 }))
            .userName(userName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [SourceCredentialArgs].
 */
@PulumiTagMarker
public class SourceCredentialArgsBuilder internal constructor() {
    private var authType: Output<String>? = null

    private var serverType: Output<String>? = null

    private var token: Output<String>? = null

    private var userName: Output<String>? = null

    /**
     * @param value The type of authentication used to connect to a GitHub, GitHub Enterprise, or Bitbucket repository. An OAUTH connection is not supported by the API.
     */
    @JvmName("fgkvnoipjcjyrcnx")
    public suspend fun authType(`value`: Output<String>) {
        this.authType = value
    }

    /**
     * @param value The source provider used for this project.
     */
    @JvmName("ilbprtssbsuxvlmi")
    public suspend fun serverType(`value`: Output<String>) {
        this.serverType = value
    }

    /**
     * @param value For `GitHub` or `GitHub Enterprise`, this is the personal access token. For `Bitbucket`, this is the app password.
     */
    @JvmName("pvpernegqokhxjux")
    public suspend fun token(`value`: Output<String>) {
        this.token = value
    }

    /**
     * @param value The Bitbucket username when the authType is `BASIC_AUTH`. This parameter is not valid for other types of source providers or connections.
     */
    @JvmName("vabgvgcmkovlcaal")
    public suspend fun userName(`value`: Output<String>) {
        this.userName = value
    }

    /**
     * @param value The type of authentication used to connect to a GitHub, GitHub Enterprise, or Bitbucket repository. An OAUTH connection is not supported by the API.
     */
    @JvmName("ikfnyhthrvyprock")
    public suspend fun authType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.authType = mapped
    }

    /**
     * @param value The source provider used for this project.
     */
    @JvmName("ukjurjutfujybsel")
    public suspend fun serverType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.serverType = mapped
    }

    /**
     * @param value For `GitHub` or `GitHub Enterprise`, this is the personal access token. For `Bitbucket`, this is the app password.
     */
    @JvmName("sgwcuevlvirrxaca")
    public suspend fun token(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.token = mapped
    }

    /**
     * @param value The Bitbucket username when the authType is `BASIC_AUTH`. This parameter is not valid for other types of source providers or connections.
     */
    @JvmName("xviqdsetlcykwmhm")
    public suspend fun userName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.userName = mapped
    }

    internal fun build(): SourceCredentialArgs = SourceCredentialArgs(
        authType = authType,
        serverType = serverType,
        token = token,
        userName = userName,
    )
}
