@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.codebuild.kotlin

import com.pulumi.aws.codebuild.WebhookArgs.builder
import com.pulumi.aws.codebuild.kotlin.inputs.WebhookFilterGroupArgs
import com.pulumi.aws.codebuild.kotlin.inputs.WebhookFilterGroupArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Manages a CodeBuild webhook, which is an endpoint accepted by the CodeBuild service to trigger builds from source code repositories. Depending on the source type of the CodeBuild project, the CodeBuild service may also automatically create and delete the actual repository webhook as well.
 * ## Example Usage
 * ### Bitbucket and GitHub
 * When working with [Bitbucket](https://bitbucket.org) and [GitHub](https://github.com) source CodeBuild webhooks, the CodeBuild service will automatically create (on `aws.codebuild.Webhook` resource creation) and delete (on `aws.codebuild.Webhook` resource deletion) the Bitbucket/GitHub repository webhook using its granted OAuth permissions. This behavior cannot be controlled by this provider.
 * > **Note:** The AWS account that this provider uses to create this resource *must* have authorized CodeBuild to access Bitbucket/GitHub's OAuth API in each applicable region. This is a manual step that must be done *before* creating webhooks with this resource. If OAuth is not configured, AWS will return an error similar to `ResourceNotFoundException: Could not find access token for server type github`. More information can be found in the CodeBuild User Guide for [Bitbucket](https://docs.aws.amazon.com/codebuild/latest/userguide/sample-bitbucket-pull-request.html) and [GitHub](https://docs.aws.amazon.com/codebuild/latest/userguide/sample-github-pull-request.html).
 * > **Note:** Further managing the automatically created Bitbucket/GitHub webhook with the `bitbucket_hook`/`github_repository_webhook` resource is only possible with importing that resource after creation of the `aws.codebuild.Webhook` resource. The CodeBuild API does not ever provide the `secret` attribute for the `aws.codebuild.Webhook` resource in this scenario.
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.codebuild.Webhook;
 * import com.pulumi.aws.codebuild.WebhookArgs;
 * import com.pulumi.aws.codebuild.inputs.WebhookFilterGroupArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Webhook("example", WebhookArgs.builder()
 *             .projectName(aws_codebuild_project.example().name())
 *             .buildType("BUILD")
 *             .filterGroups(WebhookFilterGroupArgs.builder()
 *                 .filters(
 *                     WebhookFilterGroupFilterArgs.builder()
 *                         .type("EVENT")
 *                         .pattern("PUSH")
 *                         .build(),
 *                     WebhookFilterGroupFilterArgs.builder()
 *                         .type("BASE_REF")
 *                         .pattern("master")
 *                         .build())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ### GitHub Enterprise
 * When working with [GitHub Enterprise](https://enterprise.github.com/) source CodeBuild webhooks, the GHE repository webhook must be separately managed (e.g., manually or with the `github_repository_webhook` resource).
 * More information creating webhooks with GitHub Enterprise can be found in the [CodeBuild User Guide](https://docs.aws.amazon.com/codebuild/latest/userguide/sample-github-enterprise.html).
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.codebuild.Webhook;
 * import com.pulumi.aws.codebuild.WebhookArgs;
 * import com.pulumi.github.RepositoryWebhook;
 * import com.pulumi.github.RepositoryWebhookArgs;
 * import com.pulumi.github.inputs.RepositoryWebhookConfigurationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var exampleWebhook = new Webhook("exampleWebhook", WebhookArgs.builder()
 *             .projectName(aws_codebuild_project.example().name())
 *             .build());
 *         var exampleRepositoryWebhook = new RepositoryWebhook("exampleRepositoryWebhook", RepositoryWebhookArgs.builder()
 *             .active(true)
 *             .events("push")
 *             .repository(github_repository.example().name())
 *             .configuration(RepositoryWebhookConfigurationArgs.builder()
 *                 .url(exampleWebhook.payloadUrl())
 *                 .secret(exampleWebhook.secret())
 *                 .contentType("json")
 *                 .insecureSsl(false)
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import CodeBuild Webhooks using the CodeBuild Project name. For example:
 * ```sh
 *  $ pulumi import aws:codebuild/webhook:Webhook example MyProjectName
 * ```
 * @property branchFilter A regular expression used to determine which branches get built. Default is all branches are built. We recommend using `filter_group` over `branch_filter`.
 * @property buildType The type of build this webhook will trigger. Valid values for this parameter are: `BUILD`, `BUILD_BATCH`.
 * @property filterGroups Information about the webhook's trigger. Filter group blocks are documented below.
 * @property projectName The name of the build project.
 */
public data class WebhookArgs(
    public val branchFilter: Output<String>? = null,
    public val buildType: Output<String>? = null,
    public val filterGroups: Output<List<WebhookFilterGroupArgs>>? = null,
    public val projectName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.codebuild.WebhookArgs> {
    override fun toJava(): com.pulumi.aws.codebuild.WebhookArgs =
        com.pulumi.aws.codebuild.WebhookArgs.builder()
            .branchFilter(branchFilter?.applyValue({ args0 -> args0 }))
            .buildType(buildType?.applyValue({ args0 -> args0 }))
            .filterGroups(
                filterGroups?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .projectName(projectName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [WebhookArgs].
 */
@PulumiTagMarker
public class WebhookArgsBuilder internal constructor() {
    private var branchFilter: Output<String>? = null

    private var buildType: Output<String>? = null

    private var filterGroups: Output<List<WebhookFilterGroupArgs>>? = null

    private var projectName: Output<String>? = null

    /**
     * @param value A regular expression used to determine which branches get built. Default is all branches are built. We recommend using `filter_group` over `branch_filter`.
     */
    @JvmName("podlwfopevylqfsv")
    public suspend fun branchFilter(`value`: Output<String>) {
        this.branchFilter = value
    }

    /**
     * @param value The type of build this webhook will trigger. Valid values for this parameter are: `BUILD`, `BUILD_BATCH`.
     */
    @JvmName("ydqgdaobiyuderne")
    public suspend fun buildType(`value`: Output<String>) {
        this.buildType = value
    }

    /**
     * @param value Information about the webhook's trigger. Filter group blocks are documented below.
     */
    @JvmName("asbwvjfpuqcahdqw")
    public suspend fun filterGroups(`value`: Output<List<WebhookFilterGroupArgs>>) {
        this.filterGroups = value
    }

    @JvmName("utbbodmqlphcrhnn")
    public suspend fun filterGroups(vararg values: Output<WebhookFilterGroupArgs>) {
        this.filterGroups = Output.all(values.asList())
    }

    /**
     * @param values Information about the webhook's trigger. Filter group blocks are documented below.
     */
    @JvmName("qdavogiwxwwsrcmu")
    public suspend fun filterGroups(values: List<Output<WebhookFilterGroupArgs>>) {
        this.filterGroups = Output.all(values)
    }

    /**
     * @param value The name of the build project.
     */
    @JvmName("arjutjkuwjcesofl")
    public suspend fun projectName(`value`: Output<String>) {
        this.projectName = value
    }

    /**
     * @param value A regular expression used to determine which branches get built. Default is all branches are built. We recommend using `filter_group` over `branch_filter`.
     */
    @JvmName("japouyxccjimyiki")
    public suspend fun branchFilter(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.branchFilter = mapped
    }

    /**
     * @param value The type of build this webhook will trigger. Valid values for this parameter are: `BUILD`, `BUILD_BATCH`.
     */
    @JvmName("cewrhikoqgtcwist")
    public suspend fun buildType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.buildType = mapped
    }

    /**
     * @param value Information about the webhook's trigger. Filter group blocks are documented below.
     */
    @JvmName("dvylejvujkkyfglb")
    public suspend fun filterGroups(`value`: List<WebhookFilterGroupArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.filterGroups = mapped
    }

    /**
     * @param argument Information about the webhook's trigger. Filter group blocks are documented below.
     */
    @JvmName("vbinxiokihnvkwlw")
    public suspend
    fun filterGroups(argument: List<suspend WebhookFilterGroupArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            WebhookFilterGroupArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.filterGroups = mapped
    }

    /**
     * @param argument Information about the webhook's trigger. Filter group blocks are documented below.
     */
    @JvmName("rlhdqhobsikfwreg")
    public suspend fun filterGroups(
        vararg
        argument: suspend WebhookFilterGroupArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            WebhookFilterGroupArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.filterGroups = mapped
    }

    /**
     * @param argument Information about the webhook's trigger. Filter group blocks are documented below.
     */
    @JvmName("mynnvvfwpppwqkel")
    public suspend fun filterGroups(argument: suspend WebhookFilterGroupArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(WebhookFilterGroupArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.filterGroups = mapped
    }

    /**
     * @param values Information about the webhook's trigger. Filter group blocks are documented below.
     */
    @JvmName("jxkqfsedlovlfgjm")
    public suspend fun filterGroups(vararg values: WebhookFilterGroupArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.filterGroups = mapped
    }

    /**
     * @param value The name of the build project.
     */
    @JvmName("wywnoaxshfayruxn")
    public suspend fun projectName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.projectName = mapped
    }

    internal fun build(): WebhookArgs = WebhookArgs(
        branchFilter = branchFilter,
        buildType = buildType,
        filterGroups = filterGroups,
        projectName = projectName,
    )
}
