@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.codebuild.kotlin.inputs

import com.pulumi.aws.codebuild.inputs.ProjectArtifactsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property artifactIdentifier Artifact identifier. Must be the same specified inside the AWS CodeBuild build specification.
 * @property bucketOwnerAccess Specifies the bucket owner's access for objects that another account uploads to their Amazon S3 bucket. By default, only the account that uploads the objects to the bucket has access to these objects. This property allows you to give the bucket owner access to these objects. Valid values are `NONE`, `READ_ONLY`, and `FULL`. your CodeBuild service role must have the `s3:PutBucketAcl` permission. This permission allows CodeBuild to modify the access control list for the bucket.
 * @property encryptionDisabled Whether to disable encrypting output artifacts. If `type` is set to `NO_ARTIFACTS`, this value is ignored. Defaults to `false`.
 * @property location Information about the build output artifact location. If `type` is set to `CODEPIPELINE` or `NO_ARTIFACTS`, this value is ignored. If `type` is set to `S3`, this is the name of the output bucket.
 * @property name Name of the project. If `type` is set to `S3`, this is the name of the output artifact object
 * @property namespaceType Namespace to use in storing build artifacts. If `type` is set to `S3`, then valid values are `BUILD_ID`, `NONE`.
 * @property overrideArtifactName Whether a name specified in the build specification overrides the artifact name.
 * @property packaging Type of build output artifact to create. If `type` is set to `S3`, valid values are `NONE`, `ZIP`
 * @property path If `type` is set to `S3`, this is the path to the output artifact.
 * @property type Build output artifact's type. Valid values: `CODEPIPELINE`, `NO_ARTIFACTS`, `S3`.
 */
public data class ProjectArtifactsArgs(
    public val artifactIdentifier: Output<String>? = null,
    public val bucketOwnerAccess: Output<String>? = null,
    public val encryptionDisabled: Output<Boolean>? = null,
    public val location: Output<String>? = null,
    public val name: Output<String>? = null,
    public val namespaceType: Output<String>? = null,
    public val overrideArtifactName: Output<Boolean>? = null,
    public val packaging: Output<String>? = null,
    public val path: Output<String>? = null,
    public val type: Output<String>,
) : ConvertibleToJava<com.pulumi.aws.codebuild.inputs.ProjectArtifactsArgs> {
    override fun toJava(): com.pulumi.aws.codebuild.inputs.ProjectArtifactsArgs =
        com.pulumi.aws.codebuild.inputs.ProjectArtifactsArgs.builder()
            .artifactIdentifier(artifactIdentifier?.applyValue({ args0 -> args0 }))
            .bucketOwnerAccess(bucketOwnerAccess?.applyValue({ args0 -> args0 }))
            .encryptionDisabled(encryptionDisabled?.applyValue({ args0 -> args0 }))
            .location(location?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .namespaceType(namespaceType?.applyValue({ args0 -> args0 }))
            .overrideArtifactName(overrideArtifactName?.applyValue({ args0 -> args0 }))
            .packaging(packaging?.applyValue({ args0 -> args0 }))
            .path(path?.applyValue({ args0 -> args0 }))
            .type(type.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ProjectArtifactsArgs].
 */
@PulumiTagMarker
public class ProjectArtifactsArgsBuilder internal constructor() {
    private var artifactIdentifier: Output<String>? = null

    private var bucketOwnerAccess: Output<String>? = null

    private var encryptionDisabled: Output<Boolean>? = null

    private var location: Output<String>? = null

    private var name: Output<String>? = null

    private var namespaceType: Output<String>? = null

    private var overrideArtifactName: Output<Boolean>? = null

    private var packaging: Output<String>? = null

    private var path: Output<String>? = null

    private var type: Output<String>? = null

    /**
     * @param value Artifact identifier. Must be the same specified inside the AWS CodeBuild build specification.
     */
    @JvmName("vsiyuriduvlpykcf")
    public suspend fun artifactIdentifier(`value`: Output<String>) {
        this.artifactIdentifier = value
    }

    /**
     * @param value Specifies the bucket owner's access for objects that another account uploads to their Amazon S3 bucket. By default, only the account that uploads the objects to the bucket has access to these objects. This property allows you to give the bucket owner access to these objects. Valid values are `NONE`, `READ_ONLY`, and `FULL`. your CodeBuild service role must have the `s3:PutBucketAcl` permission. This permission allows CodeBuild to modify the access control list for the bucket.
     */
    @JvmName("wlkexfdjjnapgaop")
    public suspend fun bucketOwnerAccess(`value`: Output<String>) {
        this.bucketOwnerAccess = value
    }

    /**
     * @param value Whether to disable encrypting output artifacts. If `type` is set to `NO_ARTIFACTS`, this value is ignored. Defaults to `false`.
     */
    @JvmName("klkslttfcwyrdmwu")
    public suspend fun encryptionDisabled(`value`: Output<Boolean>) {
        this.encryptionDisabled = value
    }

    /**
     * @param value Information about the build output artifact location. If `type` is set to `CODEPIPELINE` or `NO_ARTIFACTS`, this value is ignored. If `type` is set to `S3`, this is the name of the output bucket.
     */
    @JvmName("guljinxwwyuyxwvj")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value Name of the project. If `type` is set to `S3`, this is the name of the output artifact object
     */
    @JvmName("mqmfchqjoolhdefn")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Namespace to use in storing build artifacts. If `type` is set to `S3`, then valid values are `BUILD_ID`, `NONE`.
     */
    @JvmName("uhcpblmkpkwuyccu")
    public suspend fun namespaceType(`value`: Output<String>) {
        this.namespaceType = value
    }

    /**
     * @param value Whether a name specified in the build specification overrides the artifact name.
     */
    @JvmName("vjantgolcfeanotx")
    public suspend fun overrideArtifactName(`value`: Output<Boolean>) {
        this.overrideArtifactName = value
    }

    /**
     * @param value Type of build output artifact to create. If `type` is set to `S3`, valid values are `NONE`, `ZIP`
     */
    @JvmName("qgoqcvyqhuvjsqsf")
    public suspend fun packaging(`value`: Output<String>) {
        this.packaging = value
    }

    /**
     * @param value If `type` is set to `S3`, this is the path to the output artifact.
     */
    @JvmName("vflwfxcyrqdnagoo")
    public suspend fun path(`value`: Output<String>) {
        this.path = value
    }

    /**
     * @param value Build output artifact's type. Valid values: `CODEPIPELINE`, `NO_ARTIFACTS`, `S3`.
     */
    @JvmName("jayuvkxmxydkmlil")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value Artifact identifier. Must be the same specified inside the AWS CodeBuild build specification.
     */
    @JvmName("bdrmlmparyvaeyus")
    public suspend fun artifactIdentifier(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.artifactIdentifier = mapped
    }

    /**
     * @param value Specifies the bucket owner's access for objects that another account uploads to their Amazon S3 bucket. By default, only the account that uploads the objects to the bucket has access to these objects. This property allows you to give the bucket owner access to these objects. Valid values are `NONE`, `READ_ONLY`, and `FULL`. your CodeBuild service role must have the `s3:PutBucketAcl` permission. This permission allows CodeBuild to modify the access control list for the bucket.
     */
    @JvmName("ahmdafqlltboclei")
    public suspend fun bucketOwnerAccess(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.bucketOwnerAccess = mapped
    }

    /**
     * @param value Whether to disable encrypting output artifacts. If `type` is set to `NO_ARTIFACTS`, this value is ignored. Defaults to `false`.
     */
    @JvmName("nwjdrpccuugcsmsj")
    public suspend fun encryptionDisabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.encryptionDisabled = mapped
    }

    /**
     * @param value Information about the build output artifact location. If `type` is set to `CODEPIPELINE` or `NO_ARTIFACTS`, this value is ignored. If `type` is set to `S3`, this is the name of the output bucket.
     */
    @JvmName("yjpwesvsxqgbxylj")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value Name of the project. If `type` is set to `S3`, this is the name of the output artifact object
     */
    @JvmName("jdsugfrtglyhobpm")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Namespace to use in storing build artifacts. If `type` is set to `S3`, then valid values are `BUILD_ID`, `NONE`.
     */
    @JvmName("quqgrayabtkbfrkq")
    public suspend fun namespaceType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.namespaceType = mapped
    }

    /**
     * @param value Whether a name specified in the build specification overrides the artifact name.
     */
    @JvmName("mmmswfnjqrlqigud")
    public suspend fun overrideArtifactName(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.overrideArtifactName = mapped
    }

    /**
     * @param value Type of build output artifact to create. If `type` is set to `S3`, valid values are `NONE`, `ZIP`
     */
    @JvmName("yedjikuxdskskxgr")
    public suspend fun packaging(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.packaging = mapped
    }

    /**
     * @param value If `type` is set to `S3`, this is the path to the output artifact.
     */
    @JvmName("bqbuwmrrygfwrkru")
    public suspend fun path(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.path = mapped
    }

    /**
     * @param value Build output artifact's type. Valid values: `CODEPIPELINE`, `NO_ARTIFACTS`, `S3`.
     */
    @JvmName("pjberkisjryttfdj")
    public suspend fun type(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    internal fun build(): ProjectArtifactsArgs = ProjectArtifactsArgs(
        artifactIdentifier = artifactIdentifier,
        bucketOwnerAccess = bucketOwnerAccess,
        encryptionDisabled = encryptionDisabled,
        location = location,
        name = name,
        namespaceType = namespaceType,
        overrideArtifactName = overrideArtifactName,
        packaging = packaging,
        path = path,
        type = type ?: throw PulumiNullFieldException("type"),
    )
}
