@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.codebuild.kotlin.inputs

import com.pulumi.aws.codebuild.inputs.ProjectCacheArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property location Location where the AWS CodeBuild project stores cached resources. For type `S3`, the value must be a valid S3 bucket name/prefix.
 * @property modes Specifies settings that AWS CodeBuild uses to store and reuse build dependencies. Valid values:  `LOCAL_SOURCE_CACHE`, `LOCAL_DOCKER_LAYER_CACHE`, `LOCAL_CUSTOM_CACHE`.
 * @property type Type of storage that will be used for the AWS CodeBuild project cache. Valid values: `NO_CACHE`, `LOCAL`, `S3`. Defaults to `NO_CACHE`.
 */
public data class ProjectCacheArgs(
    public val location: Output<String>? = null,
    public val modes: Output<List<String>>? = null,
    public val type: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.codebuild.inputs.ProjectCacheArgs> {
    override fun toJava(): com.pulumi.aws.codebuild.inputs.ProjectCacheArgs =
        com.pulumi.aws.codebuild.inputs.ProjectCacheArgs.builder()
            .location(location?.applyValue({ args0 -> args0 }))
            .modes(modes?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .type(type?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ProjectCacheArgs].
 */
@PulumiTagMarker
public class ProjectCacheArgsBuilder internal constructor() {
    private var location: Output<String>? = null

    private var modes: Output<List<String>>? = null

    private var type: Output<String>? = null

    /**
     * @param value Location where the AWS CodeBuild project stores cached resources. For type `S3`, the value must be a valid S3 bucket name/prefix.
     */
    @JvmName("chrjdghxtamtprgt")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value Specifies settings that AWS CodeBuild uses to store and reuse build dependencies. Valid values:  `LOCAL_SOURCE_CACHE`, `LOCAL_DOCKER_LAYER_CACHE`, `LOCAL_CUSTOM_CACHE`.
     */
    @JvmName("drrijcsnslivdnoh")
    public suspend fun modes(`value`: Output<List<String>>) {
        this.modes = value
    }

    @JvmName("omjxmggygqoxftqm")
    public suspend fun modes(vararg values: Output<String>) {
        this.modes = Output.all(values.asList())
    }

    /**
     * @param values Specifies settings that AWS CodeBuild uses to store and reuse build dependencies. Valid values:  `LOCAL_SOURCE_CACHE`, `LOCAL_DOCKER_LAYER_CACHE`, `LOCAL_CUSTOM_CACHE`.
     */
    @JvmName("nrfabmgmslsrvjfl")
    public suspend fun modes(values: List<Output<String>>) {
        this.modes = Output.all(values)
    }

    /**
     * @param value Type of storage that will be used for the AWS CodeBuild project cache. Valid values: `NO_CACHE`, `LOCAL`, `S3`. Defaults to `NO_CACHE`.
     */
    @JvmName("yoygcxdwwirueqan")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value Location where the AWS CodeBuild project stores cached resources. For type `S3`, the value must be a valid S3 bucket name/prefix.
     */
    @JvmName("nxlxlgsxmluydplk")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value Specifies settings that AWS CodeBuild uses to store and reuse build dependencies. Valid values:  `LOCAL_SOURCE_CACHE`, `LOCAL_DOCKER_LAYER_CACHE`, `LOCAL_CUSTOM_CACHE`.
     */
    @JvmName("bnomkuddptgjcabq")
    public suspend fun modes(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.modes = mapped
    }

    /**
     * @param values Specifies settings that AWS CodeBuild uses to store and reuse build dependencies. Valid values:  `LOCAL_SOURCE_CACHE`, `LOCAL_DOCKER_LAYER_CACHE`, `LOCAL_CUSTOM_CACHE`.
     */
    @JvmName("vpshsajjifsxtuvj")
    public suspend fun modes(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.modes = mapped
    }

    /**
     * @param value Type of storage that will be used for the AWS CodeBuild project cache. Valid values: `NO_CACHE`, `LOCAL`, `S3`. Defaults to `NO_CACHE`.
     */
    @JvmName("yjuatdjwdrfeqtrq")
    public suspend fun type(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.type = mapped
    }

    internal fun build(): ProjectCacheArgs = ProjectCacheArgs(
        location = location,
        modes = modes,
        type = type,
    )
}
