@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.codebuild.kotlin.inputs

import com.pulumi.aws.codebuild.inputs.ProjectEnvironmentEnvironmentVariableArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property name Project's name.
 * @property type Build output artifact's type. Valid values: `CODEPIPELINE`, `NO_ARTIFACTS`, `S3`.
 * @property value Environment variable's value.
 */
public data class ProjectEnvironmentEnvironmentVariableArgs(
    public val name: Output<String>,
    public val type: Output<String>? = null,
    public val `value`: Output<String>,
) : ConvertibleToJava<com.pulumi.aws.codebuild.inputs.ProjectEnvironmentEnvironmentVariableArgs> {
    override fun toJava(): com.pulumi.aws.codebuild.inputs.ProjectEnvironmentEnvironmentVariableArgs =
        com.pulumi.aws.codebuild.inputs.ProjectEnvironmentEnvironmentVariableArgs.builder()
            .name(name.applyValue({ args0 -> args0 }))
            .type(type?.applyValue({ args0 -> args0 }))
            .`value`(`value`.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ProjectEnvironmentEnvironmentVariableArgs].
 */
@PulumiTagMarker
public class ProjectEnvironmentEnvironmentVariableArgsBuilder internal constructor() {
    private var name: Output<String>? = null

    private var type: Output<String>? = null

    private var `value`: Output<String>? = null

    /**
     * @param value Project's name.
     */
    @JvmName("rpqcxpfjonvvatjt")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Build output artifact's type. Valid values: `CODEPIPELINE`, `NO_ARTIFACTS`, `S3`.
     */
    @JvmName("qyvlmjyxkyqsdjrd")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value Environment variable's value.
     */
    @JvmName("srimotiaxiubwedm")
    public suspend fun `value`(`value`: Output<String>) {
        this.`value` = value
    }

    /**
     * @param value Project's name.
     */
    @JvmName("svhxmraewyxghyak")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Build output artifact's type. Valid values: `CODEPIPELINE`, `NO_ARTIFACTS`, `S3`.
     */
    @JvmName("kincmyujhxlyogwn")
    public suspend fun type(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value Environment variable's value.
     */
    @JvmName("xrmyixdccloyoimm")
    public suspend fun `value`(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.`value` = mapped
    }

    internal fun build(): ProjectEnvironmentEnvironmentVariableArgs =
        ProjectEnvironmentEnvironmentVariableArgs(
            name = name ?: throw PulumiNullFieldException("name"),
            type = type,
            `value` = `value` ?: throw PulumiNullFieldException("value"),
        )
}
