@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.codebuild.kotlin.inputs

import com.pulumi.aws.codebuild.inputs.ProjectFileSystemLocationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property identifier The name used to access a file system created by Amazon EFS. CodeBuild creates an environment variable by appending the identifier in all capital letters to CODEBUILD\_. For example, if you specify my-efs for identifier, a new environment variable is create named CODEBUILD_MY-EFS.
 * @property location A string that specifies the location of the file system created by Amazon EFS. Its format is `efs-dns-name:/directory-path`.
 * @property mountOptions The mount options for a file system created by AWS EFS.
 * @property mountPoint The location in the container where you mount the file system.
 * @property type The type of the file system. The one supported type is `EFS`.
 */
public data class ProjectFileSystemLocationArgs(
    public val identifier: Output<String>? = null,
    public val location: Output<String>? = null,
    public val mountOptions: Output<String>? = null,
    public val mountPoint: Output<String>? = null,
    public val type: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.codebuild.inputs.ProjectFileSystemLocationArgs> {
    override fun toJava(): com.pulumi.aws.codebuild.inputs.ProjectFileSystemLocationArgs =
        com.pulumi.aws.codebuild.inputs.ProjectFileSystemLocationArgs.builder()
            .identifier(identifier?.applyValue({ args0 -> args0 }))
            .location(location?.applyValue({ args0 -> args0 }))
            .mountOptions(mountOptions?.applyValue({ args0 -> args0 }))
            .mountPoint(mountPoint?.applyValue({ args0 -> args0 }))
            .type(type?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ProjectFileSystemLocationArgs].
 */
@PulumiTagMarker
public class ProjectFileSystemLocationArgsBuilder internal constructor() {
    private var identifier: Output<String>? = null

    private var location: Output<String>? = null

    private var mountOptions: Output<String>? = null

    private var mountPoint: Output<String>? = null

    private var type: Output<String>? = null

    /**
     * @param value The name used to access a file system created by Amazon EFS. CodeBuild creates an environment variable by appending the identifier in all capital letters to CODEBUILD\_. For example, if you specify my-efs for identifier, a new environment variable is create named CODEBUILD_MY-EFS.
     */
    @JvmName("unmwoviwwyqdcujf")
    public suspend fun identifier(`value`: Output<String>) {
        this.identifier = value
    }

    /**
     * @param value A string that specifies the location of the file system created by Amazon EFS. Its format is `efs-dns-name:/directory-path`.
     */
    @JvmName("nfumbwfftroyeefd")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value The mount options for a file system created by AWS EFS.
     */
    @JvmName("hswgxknbiaobdbpn")
    public suspend fun mountOptions(`value`: Output<String>) {
        this.mountOptions = value
    }

    /**
     * @param value The location in the container where you mount the file system.
     */
    @JvmName("bhthmhagfmoegbrs")
    public suspend fun mountPoint(`value`: Output<String>) {
        this.mountPoint = value
    }

    /**
     * @param value The type of the file system. The one supported type is `EFS`.
     */
    @JvmName("joenijebejhjfmtw")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value The name used to access a file system created by Amazon EFS. CodeBuild creates an environment variable by appending the identifier in all capital letters to CODEBUILD\_. For example, if you specify my-efs for identifier, a new environment variable is create named CODEBUILD_MY-EFS.
     */
    @JvmName("ibqboafqmmpxpjwq")
    public suspend fun identifier(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.identifier = mapped
    }

    /**
     * @param value A string that specifies the location of the file system created by Amazon EFS. Its format is `efs-dns-name:/directory-path`.
     */
    @JvmName("mongfdwfmyqwbmjn")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value The mount options for a file system created by AWS EFS.
     */
    @JvmName("pclxhbmuuwujxrhp")
    public suspend fun mountOptions(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.mountOptions = mapped
    }

    /**
     * @param value The location in the container where you mount the file system.
     */
    @JvmName("ysjbmjeqdsrwekft")
    public suspend fun mountPoint(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.mountPoint = mapped
    }

    /**
     * @param value The type of the file system. The one supported type is `EFS`.
     */
    @JvmName("mawhwlcuigdrtlru")
    public suspend fun type(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.type = mapped
    }

    internal fun build(): ProjectFileSystemLocationArgs = ProjectFileSystemLocationArgs(
        identifier = identifier,
        location = location,
        mountOptions = mountOptions,
        mountPoint = mountPoint,
        type = type,
    )
}
