@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.codebuild.kotlin.inputs

import com.pulumi.aws.codebuild.inputs.ProjectSecondarySourceArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property buildStatusConfig Configuration block that contains information that defines how the build project reports the build status to the source provider. This option is only used when the source provider is `GITHUB`, `GITHUB_ENTERPRISE`, or `BITBUCKET`. `build_status_config` blocks are documented below.
 * @property buildspec The build spec declaration to use for this build project's related builds. This must be set when `type` is `NO_SOURCE`. It can either be a path to a file residing in the repository to be built or a local file path leveraging the `file()` built-in.
 * @property gitCloneDepth Truncate git history to this many commits. Use `0` for a `Full` checkout which you need to run commands like `git branch --show-current`. See [AWS CodePipeline User Guide: Tutorial: Use full clone with a GitHub pipeline source](https://docs.aws.amazon.com/codepipeline/latest/userguide/tutorials-github-gitclone.html) for details.
 * @property gitSubmodulesConfig Configuration block. Detailed below.
 * @property insecureSsl Ignore SSL warnings when connecting to source control.
 * @property location Location of the source code from git or s3.
 * @property reportBuildStatus Whether to report the status of a build's start and finish to your source provider. This option is only valid when your source provider is `GITHUB`, `BITBUCKET`, or `GITHUB_ENTERPRISE`.
 * @property sourceIdentifier An identifier for this project source. The identifier can only contain alphanumeric characters and underscores, and must be less than 128 characters in length.
 * @property type Type of repository that contains the source code to be built. Valid values: `CODECOMMIT`, `CODEPIPELINE`, `GITHUB`, `GITHUB_ENTERPRISE`, `BITBUCKET` or `S3`.
 */
public data class ProjectSecondarySourceArgs(
    public val buildStatusConfig: Output<ProjectSecondarySourceBuildStatusConfigArgs>? = null,
    public val buildspec: Output<String>? = null,
    public val gitCloneDepth: Output<Int>? = null,
    public val gitSubmodulesConfig: Output<ProjectSecondarySourceGitSubmodulesConfigArgs>? = null,
    public val insecureSsl: Output<Boolean>? = null,
    public val location: Output<String>? = null,
    public val reportBuildStatus: Output<Boolean>? = null,
    public val sourceIdentifier: Output<String>,
    public val type: Output<String>,
) : ConvertibleToJava<com.pulumi.aws.codebuild.inputs.ProjectSecondarySourceArgs> {
    override fun toJava(): com.pulumi.aws.codebuild.inputs.ProjectSecondarySourceArgs =
        com.pulumi.aws.codebuild.inputs.ProjectSecondarySourceArgs.builder()
            .buildStatusConfig(buildStatusConfig?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .buildspec(buildspec?.applyValue({ args0 -> args0 }))
            .gitCloneDepth(gitCloneDepth?.applyValue({ args0 -> args0 }))
            .gitSubmodulesConfig(
                gitSubmodulesConfig?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .insecureSsl(insecureSsl?.applyValue({ args0 -> args0 }))
            .location(location?.applyValue({ args0 -> args0 }))
            .reportBuildStatus(reportBuildStatus?.applyValue({ args0 -> args0 }))
            .sourceIdentifier(sourceIdentifier.applyValue({ args0 -> args0 }))
            .type(type.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ProjectSecondarySourceArgs].
 */
@PulumiTagMarker
public class ProjectSecondarySourceArgsBuilder internal constructor() {
    private var buildStatusConfig: Output<ProjectSecondarySourceBuildStatusConfigArgs>? = null

    private var buildspec: Output<String>? = null

    private var gitCloneDepth: Output<Int>? = null

    private var gitSubmodulesConfig: Output<ProjectSecondarySourceGitSubmodulesConfigArgs>? = null

    private var insecureSsl: Output<Boolean>? = null

    private var location: Output<String>? = null

    private var reportBuildStatus: Output<Boolean>? = null

    private var sourceIdentifier: Output<String>? = null

    private var type: Output<String>? = null

    /**
     * @param value Configuration block that contains information that defines how the build project reports the build status to the source provider. This option is only used when the source provider is `GITHUB`, `GITHUB_ENTERPRISE`, or `BITBUCKET`. `build_status_config` blocks are documented below.
     */
    @JvmName("yhtwvltqjoxwyujk")
    public suspend
    fun buildStatusConfig(`value`: Output<ProjectSecondarySourceBuildStatusConfigArgs>) {
        this.buildStatusConfig = value
    }

    /**
     * @param value The build spec declaration to use for this build project's related builds. This must be set when `type` is `NO_SOURCE`. It can either be a path to a file residing in the repository to be built or a local file path leveraging the `file()` built-in.
     */
    @JvmName("xgsywpwpmpdrtwhe")
    public suspend fun buildspec(`value`: Output<String>) {
        this.buildspec = value
    }

    /**
     * @param value Truncate git history to this many commits. Use `0` for a `Full` checkout which you need to run commands like `git branch --show-current`. See [AWS CodePipeline User Guide: Tutorial: Use full clone with a GitHub pipeline source](https://docs.aws.amazon.com/codepipeline/latest/userguide/tutorials-github-gitclone.html) for details.
     */
    @JvmName("ieddaigxqbgckcfo")
    public suspend fun gitCloneDepth(`value`: Output<Int>) {
        this.gitCloneDepth = value
    }

    /**
     * @param value Configuration block. Detailed below.
     */
    @JvmName("gqvoeenynsjvmakl")
    public suspend
    fun gitSubmodulesConfig(`value`: Output<ProjectSecondarySourceGitSubmodulesConfigArgs>) {
        this.gitSubmodulesConfig = value
    }

    /**
     * @param value Ignore SSL warnings when connecting to source control.
     */
    @JvmName("acaewbjyygvjvmdt")
    public suspend fun insecureSsl(`value`: Output<Boolean>) {
        this.insecureSsl = value
    }

    /**
     * @param value Location of the source code from git or s3.
     */
    @JvmName("frovtpwpbdararyy")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value Whether to report the status of a build's start and finish to your source provider. This option is only valid when your source provider is `GITHUB`, `BITBUCKET`, or `GITHUB_ENTERPRISE`.
     */
    @JvmName("hfnifyruarhbasij")
    public suspend fun reportBuildStatus(`value`: Output<Boolean>) {
        this.reportBuildStatus = value
    }

    /**
     * @param value An identifier for this project source. The identifier can only contain alphanumeric characters and underscores, and must be less than 128 characters in length.
     */
    @JvmName("ulxlfemxmanjufrk")
    public suspend fun sourceIdentifier(`value`: Output<String>) {
        this.sourceIdentifier = value
    }

    /**
     * @param value Type of repository that contains the source code to be built. Valid values: `CODECOMMIT`, `CODEPIPELINE`, `GITHUB`, `GITHUB_ENTERPRISE`, `BITBUCKET` or `S3`.
     */
    @JvmName("jjufmraxfjctbxju")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value Configuration block that contains information that defines how the build project reports the build status to the source provider. This option is only used when the source provider is `GITHUB`, `GITHUB_ENTERPRISE`, or `BITBUCKET`. `build_status_config` blocks are documented below.
     */
    @JvmName("gukmvyhpjckjyokp")
    public suspend fun buildStatusConfig(`value`: ProjectSecondarySourceBuildStatusConfigArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.buildStatusConfig = mapped
    }

    /**
     * @param argument Configuration block that contains information that defines how the build project reports the build status to the source provider. This option is only used when the source provider is `GITHUB`, `GITHUB_ENTERPRISE`, or `BITBUCKET`. `build_status_config` blocks are documented below.
     */
    @JvmName("rjpwbwcfjcyshtmi")
    public suspend
    fun buildStatusConfig(argument: suspend ProjectSecondarySourceBuildStatusConfigArgsBuilder.() -> Unit) {
        val toBeMapped = ProjectSecondarySourceBuildStatusConfigArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.buildStatusConfig = mapped
    }

    /**
     * @param value The build spec declaration to use for this build project's related builds. This must be set when `type` is `NO_SOURCE`. It can either be a path to a file residing in the repository to be built or a local file path leveraging the `file()` built-in.
     */
    @JvmName("lofouhvydimnitks")
    public suspend fun buildspec(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.buildspec = mapped
    }

    /**
     * @param value Truncate git history to this many commits. Use `0` for a `Full` checkout which you need to run commands like `git branch --show-current`. See [AWS CodePipeline User Guide: Tutorial: Use full clone with a GitHub pipeline source](https://docs.aws.amazon.com/codepipeline/latest/userguide/tutorials-github-gitclone.html) for details.
     */
    @JvmName("pljcfvgxrhiofgqy")
    public suspend fun gitCloneDepth(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.gitCloneDepth = mapped
    }

    /**
     * @param value Configuration block. Detailed below.
     */
    @JvmName("tidtiiallcmambwo")
    public suspend fun gitSubmodulesConfig(`value`: ProjectSecondarySourceGitSubmodulesConfigArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.gitSubmodulesConfig = mapped
    }

    /**
     * @param argument Configuration block. Detailed below.
     */
    @JvmName("fawkdtluusjqpsqv")
    public suspend
    fun gitSubmodulesConfig(argument: suspend ProjectSecondarySourceGitSubmodulesConfigArgsBuilder.() -> Unit) {
        val toBeMapped = ProjectSecondarySourceGitSubmodulesConfigArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.gitSubmodulesConfig = mapped
    }

    /**
     * @param value Ignore SSL warnings when connecting to source control.
     */
    @JvmName("wyamhhiprebrmxgi")
    public suspend fun insecureSsl(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.insecureSsl = mapped
    }

    /**
     * @param value Location of the source code from git or s3.
     */
    @JvmName("jfhlffybkssahnwh")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value Whether to report the status of a build's start and finish to your source provider. This option is only valid when your source provider is `GITHUB`, `BITBUCKET`, or `GITHUB_ENTERPRISE`.
     */
    @JvmName("jdogicciacowioyt")
    public suspend fun reportBuildStatus(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.reportBuildStatus = mapped
    }

    /**
     * @param value An identifier for this project source. The identifier can only contain alphanumeric characters and underscores, and must be less than 128 characters in length.
     */
    @JvmName("qmecdoefpveixolt")
    public suspend fun sourceIdentifier(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.sourceIdentifier = mapped
    }

    /**
     * @param value Type of repository that contains the source code to be built. Valid values: `CODECOMMIT`, `CODEPIPELINE`, `GITHUB`, `GITHUB_ENTERPRISE`, `BITBUCKET` or `S3`.
     */
    @JvmName("vtdxgxclbxrhpksc")
    public suspend fun type(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    internal fun build(): ProjectSecondarySourceArgs = ProjectSecondarySourceArgs(
        buildStatusConfig = buildStatusConfig,
        buildspec = buildspec,
        gitCloneDepth = gitCloneDepth,
        gitSubmodulesConfig = gitSubmodulesConfig,
        insecureSsl = insecureSsl,
        location = location,
        reportBuildStatus = reportBuildStatus,
        sourceIdentifier = sourceIdentifier ?: throw PulumiNullFieldException("sourceIdentifier"),
        type = type ?: throw PulumiNullFieldException("type"),
    )
}
