@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.codebuild.kotlin.inputs

import com.pulumi.aws.codebuild.inputs.ProjectSecondarySourceBuildStatusConfigArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property context Specifies the context of the build status CodeBuild sends to the source provider. The usage of this parameter depends on the source provider.
 * @property targetUrl Specifies the target url of the build status CodeBuild sends to the source provider. The usage of this parameter depends on the source provider.
 */
public data class ProjectSecondarySourceBuildStatusConfigArgs(
    public val context: Output<String>? = null,
    public val targetUrl: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.codebuild.inputs.ProjectSecondarySourceBuildStatusConfigArgs> {
    override fun toJava(): com.pulumi.aws.codebuild.inputs.ProjectSecondarySourceBuildStatusConfigArgs =
        com.pulumi.aws.codebuild.inputs.ProjectSecondarySourceBuildStatusConfigArgs.builder()
            .context(context?.applyValue({ args0 -> args0 }))
            .targetUrl(targetUrl?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ProjectSecondarySourceBuildStatusConfigArgs].
 */
@PulumiTagMarker
public class ProjectSecondarySourceBuildStatusConfigArgsBuilder internal constructor() {
    private var context: Output<String>? = null

    private var targetUrl: Output<String>? = null

    /**
     * @param value Specifies the context of the build status CodeBuild sends to the source provider. The usage of this parameter depends on the source provider.
     */
    @JvmName("dfrevfcrhdinvfbu")
    public suspend fun context(`value`: Output<String>) {
        this.context = value
    }

    /**
     * @param value Specifies the target url of the build status CodeBuild sends to the source provider. The usage of this parameter depends on the source provider.
     */
    @JvmName("hyxtdefitvyitswl")
    public suspend fun targetUrl(`value`: Output<String>) {
        this.targetUrl = value
    }

    /**
     * @param value Specifies the context of the build status CodeBuild sends to the source provider. The usage of this parameter depends on the source provider.
     */
    @JvmName("ibmmymomnnuwtvpl")
    public suspend fun context(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.context = mapped
    }

    /**
     * @param value Specifies the target url of the build status CodeBuild sends to the source provider. The usage of this parameter depends on the source provider.
     */
    @JvmName("ewuwrdmsyksrdvui")
    public suspend fun targetUrl(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.targetUrl = mapped
    }

    internal fun build(): ProjectSecondarySourceBuildStatusConfigArgs =
        ProjectSecondarySourceBuildStatusConfigArgs(
            context = context,
            targetUrl = targetUrl,
        )
}
