@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.codebuild.kotlin.inputs

import com.pulumi.aws.codebuild.inputs.ProjectSecondarySourceGitSubmodulesConfigArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property fetchSubmodules Whether to fetch Git submodules for the AWS CodeBuild build project.
 */
public data class ProjectSecondarySourceGitSubmodulesConfigArgs(
    public val fetchSubmodules: Output<Boolean>,
) : ConvertibleToJava<com.pulumi.aws.codebuild.inputs.ProjectSecondarySourceGitSubmodulesConfigArgs> {
    override fun toJava():
        com.pulumi.aws.codebuild.inputs.ProjectSecondarySourceGitSubmodulesConfigArgs =
        com.pulumi.aws.codebuild.inputs.ProjectSecondarySourceGitSubmodulesConfigArgs.builder()
            .fetchSubmodules(fetchSubmodules.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ProjectSecondarySourceGitSubmodulesConfigArgs].
 */
@PulumiTagMarker
public class ProjectSecondarySourceGitSubmodulesConfigArgsBuilder internal constructor() {
    private var fetchSubmodules: Output<Boolean>? = null

    /**
     * @param value Whether to fetch Git submodules for the AWS CodeBuild build project.
     */
    @JvmName("xxafukfocosyeglp")
    public suspend fun fetchSubmodules(`value`: Output<Boolean>) {
        this.fetchSubmodules = value
    }

    /**
     * @param value Whether to fetch Git submodules for the AWS CodeBuild build project.
     */
    @JvmName("jnmvwmvgelmdrlim")
    public suspend fun fetchSubmodules(`value`: Boolean) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.fetchSubmodules = mapped
    }

    internal fun build(): ProjectSecondarySourceGitSubmodulesConfigArgs =
        ProjectSecondarySourceGitSubmodulesConfigArgs(
            fetchSubmodules = fetchSubmodules ?: throw PulumiNullFieldException("fetchSubmodules"),
        )
}
