@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.codebuild.kotlin.inputs

import com.pulumi.aws.codebuild.inputs.ReportGroupExportConfigArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property s3Destination contains information about the S3 bucket where the run of a report is exported. see S3 Destination documented below.
 * @property type The export configuration type. Valid values are `S3` and `NO_EXPORT`.
 */
public data class ReportGroupExportConfigArgs(
    public val s3Destination: Output<ReportGroupExportConfigS3DestinationArgs>? = null,
    public val type: Output<String>,
) : ConvertibleToJava<com.pulumi.aws.codebuild.inputs.ReportGroupExportConfigArgs> {
    override fun toJava(): com.pulumi.aws.codebuild.inputs.ReportGroupExportConfigArgs =
        com.pulumi.aws.codebuild.inputs.ReportGroupExportConfigArgs.builder()
            .s3Destination(s3Destination?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .type(type.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ReportGroupExportConfigArgs].
 */
@PulumiTagMarker
public class ReportGroupExportConfigArgsBuilder internal constructor() {
    private var s3Destination: Output<ReportGroupExportConfigS3DestinationArgs>? = null

    private var type: Output<String>? = null

    /**
     * @param value contains information about the S3 bucket where the run of a report is exported. see S3 Destination documented below.
     */
    @JvmName("scnbyfabftbakvvs")
    public suspend fun s3Destination(`value`: Output<ReportGroupExportConfigS3DestinationArgs>) {
        this.s3Destination = value
    }

    /**
     * @param value The export configuration type. Valid values are `S3` and `NO_EXPORT`.
     */
    @JvmName("tstnenhkcoqeobio")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value contains information about the S3 bucket where the run of a report is exported. see S3 Destination documented below.
     */
    @JvmName("leusfuhnhjjynawe")
    public suspend fun s3Destination(`value`: ReportGroupExportConfigS3DestinationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.s3Destination = mapped
    }

    /**
     * @param argument contains information about the S3 bucket where the run of a report is exported. see S3 Destination documented below.
     */
    @JvmName("qqiyxwdicxlwqgnr")
    public suspend
    fun s3Destination(argument: suspend ReportGroupExportConfigS3DestinationArgsBuilder.() -> Unit) {
        val toBeMapped = ReportGroupExportConfigS3DestinationArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.s3Destination = mapped
    }

    /**
     * @param value The export configuration type. Valid values are `S3` and `NO_EXPORT`.
     */
    @JvmName("wjkenjljrjeqgptn")
    public suspend fun type(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    internal fun build(): ReportGroupExportConfigArgs = ReportGroupExportConfigArgs(
        s3Destination = s3Destination,
        type = type ?: throw PulumiNullFieldException("type"),
    )
}
