@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.codebuild.kotlin.inputs

import com.pulumi.aws.codebuild.inputs.ReportGroupExportConfigS3DestinationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property bucket The name of the S3 bucket where the raw data of a report are exported.
 * @property encryptionDisabled A boolean value that specifies if the results of a report are encrypted.
 * **Note: the API does not currently allow setting encryption as disabled**
 * @property encryptionKey The encryption key for the report's encrypted raw data. The KMS key ARN.
 * @property packaging The type of build output artifact to create. Valid values are: `NONE` (default) and `ZIP`.
 * @property path The path to the exported report's raw data results.
 */
public data class ReportGroupExportConfigS3DestinationArgs(
    public val bucket: Output<String>,
    public val encryptionDisabled: Output<Boolean>? = null,
    public val encryptionKey: Output<String>,
    public val packaging: Output<String>? = null,
    public val path: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.codebuild.inputs.ReportGroupExportConfigS3DestinationArgs> {
    override fun toJava(): com.pulumi.aws.codebuild.inputs.ReportGroupExportConfigS3DestinationArgs =
        com.pulumi.aws.codebuild.inputs.ReportGroupExportConfigS3DestinationArgs.builder()
            .bucket(bucket.applyValue({ args0 -> args0 }))
            .encryptionDisabled(encryptionDisabled?.applyValue({ args0 -> args0 }))
            .encryptionKey(encryptionKey.applyValue({ args0 -> args0 }))
            .packaging(packaging?.applyValue({ args0 -> args0 }))
            .path(path?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ReportGroupExportConfigS3DestinationArgs].
 */
@PulumiTagMarker
public class ReportGroupExportConfigS3DestinationArgsBuilder internal constructor() {
    private var bucket: Output<String>? = null

    private var encryptionDisabled: Output<Boolean>? = null

    private var encryptionKey: Output<String>? = null

    private var packaging: Output<String>? = null

    private var path: Output<String>? = null

    /**
     * @param value The name of the S3 bucket where the raw data of a report are exported.
     */
    @JvmName("enwhfjntmtvfkrdc")
    public suspend fun bucket(`value`: Output<String>) {
        this.bucket = value
    }

    /**
     * @param value A boolean value that specifies if the results of a report are encrypted.
     * **Note: the API does not currently allow setting encryption as disabled**
     */
    @JvmName("xcqhnwojlfudeibe")
    public suspend fun encryptionDisabled(`value`: Output<Boolean>) {
        this.encryptionDisabled = value
    }

    /**
     * @param value The encryption key for the report's encrypted raw data. The KMS key ARN.
     */
    @JvmName("iyxpksopkcistbbm")
    public suspend fun encryptionKey(`value`: Output<String>) {
        this.encryptionKey = value
    }

    /**
     * @param value The type of build output artifact to create. Valid values are: `NONE` (default) and `ZIP`.
     */
    @JvmName("kbcbeljwqfvvwsge")
    public suspend fun packaging(`value`: Output<String>) {
        this.packaging = value
    }

    /**
     * @param value The path to the exported report's raw data results.
     */
    @JvmName("npibcwrxpypjipng")
    public suspend fun path(`value`: Output<String>) {
        this.path = value
    }

    /**
     * @param value The name of the S3 bucket where the raw data of a report are exported.
     */
    @JvmName("bjbvruinohkabbmy")
    public suspend fun bucket(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.bucket = mapped
    }

    /**
     * @param value A boolean value that specifies if the results of a report are encrypted.
     * **Note: the API does not currently allow setting encryption as disabled**
     */
    @JvmName("sqauvbdwqxkxcerf")
    public suspend fun encryptionDisabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.encryptionDisabled = mapped
    }

    /**
     * @param value The encryption key for the report's encrypted raw data. The KMS key ARN.
     */
    @JvmName("ngvabrvxoefwrfcu")
    public suspend fun encryptionKey(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.encryptionKey = mapped
    }

    /**
     * @param value The type of build output artifact to create. Valid values are: `NONE` (default) and `ZIP`.
     */
    @JvmName("gnsrtftymflcwyvy")
    public suspend fun packaging(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.packaging = mapped
    }

    /**
     * @param value The path to the exported report's raw data results.
     */
    @JvmName("tpxwlpvvxspfrwos")
    public suspend fun path(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.path = mapped
    }

    internal fun build(): ReportGroupExportConfigS3DestinationArgs =
        ReportGroupExportConfigS3DestinationArgs(
            bucket = bucket ?: throw PulumiNullFieldException("bucket"),
            encryptionDisabled = encryptionDisabled,
            encryptionKey = encryptionKey ?: throw PulumiNullFieldException("encryptionKey"),
            packaging = packaging,
            path = path,
        )
}
