@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.codebuild.kotlin.outputs

import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property combineArtifacts Specifies if the build artifacts for the batch build should be combined into a single artifact location.
 * @property restrictions Configuration block specifying the restrictions for the batch build. Detailed below.
 * @property serviceRole Specifies the service role ARN for the batch build project.
 * @property timeoutInMins Specifies the maximum amount of time, in minutes, that the batch build must be completed in.
 */
public data class ProjectBuildBatchConfig(
    public val combineArtifacts: Boolean? = null,
    public val restrictions: ProjectBuildBatchConfigRestrictions? = null,
    public val serviceRole: String,
    public val timeoutInMins: Int? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.codebuild.outputs.ProjectBuildBatchConfig):
            ProjectBuildBatchConfig = ProjectBuildBatchConfig(
            combineArtifacts = javaType.combineArtifacts().map({ args0 -> args0 }).orElse(null),
            restrictions = javaType.restrictions().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.codebuild.kotlin.outputs.ProjectBuildBatchConfigRestrictions.Companion.toKotlin(args0)
                })
            }).orElse(null),
            serviceRole = javaType.serviceRole(),
            timeoutInMins = javaType.timeoutInMins().map({ args0 -> args0 }).orElse(null),
        )
    }
}
