@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.codebuild.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property certificate ARN of the S3 bucket, path prefix and object key that contains the PEM-encoded certificate.
 * @property computeType Information about the compute resources the build project will use. Valid values: `BUILD_GENERAL1_SMALL`, `BUILD_GENERAL1_MEDIUM`, `BUILD_GENERAL1_LARGE`, `BUILD_GENERAL1_2XLARGE`. `BUILD_GENERAL1_SMALL` is only valid if `type` is set to `LINUX_CONTAINER`. When `type` is set to `LINUX_GPU_CONTAINER`, `compute_type` must be `BUILD_GENERAL1_LARGE`.
 * @property environmentVariables Configuration block. Detailed below.
 * @property image Docker image to use for this build project. Valid values include [Docker images provided by CodeBuild](https://docs&#46;aws&#46;amazon&#46;com/codebuild/latest/userguide/build-env-ref-available&#46;html) (e&#46;g `aws/codebuild/amazonlinux2-x86_64-standard:4&#46;0`), [Docker Hub images](https://hub.docker.com/) (e.g., `pulumi/pulumi:latest`), and full Docker repository URIs such as those for ECR (e.g., `137112412989.dkr.ecr.us-west-2.amazonaws.com/amazonlinux:latest`).
 * @property imagePullCredentialsType Type of credentials AWS CodeBuild uses to pull images in your build. Valid values: `CODEBUILD`, `SERVICE_ROLE`. When you use a cross-account or private registry image, you must use SERVICE_ROLE credentials. When you use an AWS CodeBuild curated image, you must use CodeBuild credentials. Defaults to `CODEBUILD`.
 * @property privilegedMode Whether to enable running the Docker daemon inside a Docker container. Defaults to `false`.
 * @property registryCredential Configuration block. Detailed below.
 * @property type Type of environment variable. Valid values: `PARAMETER_STORE`, `PLAINTEXT`, `SECRETS_MANAGER`.
 */
public data class ProjectEnvironment(
    public val certificate: String? = null,
    public val computeType: String,
    public val environmentVariables: List<ProjectEnvironmentEnvironmentVariable>? = null,
    public val image: String,
    public val imagePullCredentialsType: String? = null,
    public val privilegedMode: Boolean? = null,
    public val registryCredential: ProjectEnvironmentRegistryCredential? = null,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.codebuild.outputs.ProjectEnvironment):
            ProjectEnvironment = ProjectEnvironment(
            certificate = javaType.certificate().map({ args0 -> args0 }).orElse(null),
            computeType = javaType.computeType(),
            environmentVariables = javaType.environmentVariables().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.codebuild.kotlin.outputs.ProjectEnvironmentEnvironmentVariable.Companion.toKotlin(args0)
                })
            }),
            image = javaType.image(),
            imagePullCredentialsType = javaType.imagePullCredentialsType().map({ args0 -> args0 }).orElse(null),
            privilegedMode = javaType.privilegedMode().map({ args0 -> args0 }).orElse(null),
            registryCredential = javaType.registryCredential().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.codebuild.kotlin.outputs.ProjectEnvironmentRegistryCredential.Companion.toKotlin(args0)
                })
            }).orElse(null),
            type = javaType.type(),
        )
    }
}
